/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.certificate;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.Certificate;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ICertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ICertificateService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertificateVo;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

@DubboService
public class CertificateProviderServiceImpl
implements ICertificateProviderService {
    private final ICertificateService certificateService;

    public LayuiGridData<CertificateVo> getCertificateList(PageParam param) {
        return this.certificateService.getCertificatePageList(param);
    }

    public List<Certificate> getCertificateList() {
        return this.certificateService.getCertificateList();
    }

    public Certificate getCertificateDetailById(Long id) {
        if (id == null) {
            throw new ServiceException("id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return (Certificate)this.certificateService.getById(id);
    }

    public void addCertificate(Certificate certificate) {
        this.certificateService.save(certificate);
    }

    public void updateCertificate(Certificate certificate) {
        FieldCheckUtils.checkEmptyFields((Object)certificate, (String[])new String[]{"id"});
        this.certificateService.updateById(certificate);
    }

    public boolean updateStatus(Long id, Integer status) {
        if (id == null || status == null) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return this.certificateService.updateStatus(id, status);
    }

    public boolean updateStatusBatch(List<Long> ids, Integer status) {
        if (CollectionUtils.isEmpty(ids) || status == null) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return this.certificateService.updateStatusBatch(ids, status);
    }

    public void deleteBatch(IdsParam ids) {
        List idList = ids.getIdList();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        this.certificateService.removeByIds(idList);
    }

    @Generated
    public CertificateProviderServiceImpl(ICertificateService certificateService) {
        this.certificateService = certificateService;
    }
}

