/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.service.zlb;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.json.utils.JsonUtils;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.radiationTraining.modules.wx.service.zlb.HmacAuthUtil;
import cn.smarthse.radiationTraining.modules.wx.service.zlb.IZlbClientServiceService;
import com.alibaba.fastjson2.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ZlbClientServiceService
implements IZlbClientServiceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbClientServiceService.class);
    private static final String access_token = "/restapi/prod/IC33000020220329000007/uc/sso/access_token";
    private static final String getUserInfo = "/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo";
    @Value(value="${zlb.host}")
    private String host;
    @Value(value="${zlb.appKey}")
    private String appKey;
    @Value(value="${zlb.appSecret}")
    private String appSecret;
    private final RestTemplate restTemplate;

    @Override
    public String getClientTicketCode(String ticketId, String appKey, String appSecret, String appId) {
        String url = this.host + access_token;
        Map<String, String> header = HmacAuthUtil.generateHeader(url, "POST", appKey, appSecret);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("ticketId", ticketId);
        params.put("appId", appId);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42start\uff1a{}", (Object)ticketId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAll(header);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)new HttpEntity(params, (MultiValueMap)headers), String.class, new Object[0]);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42end\uff1a{}", forEntity.getBody());
        JSONObject resultJson = JSONObject.parseObject((String)((String)forEntity.getBody()));
        if (resultJson.getBoolean("success").booleanValue()) {
            return ((JSONObject)resultJson.get("data")).getString("accessToken");
        }
        return null;
    }

    @Override
    public ZlbUserInfo getClientInfoByToken(String token, String appKey, String appSecret) {
        String url = this.host + getUserInfo;
        Map<String, String> header = HmacAuthUtil.generateHeader(url, "POST", appKey, appSecret);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("token", token);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606fstart\uff1a{}", (Object)token);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAll(header);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)new HttpEntity(params, (MultiValueMap)headers), String.class, new Object[0]);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606fend\uff1a{}", forEntity.getBody());
        JSONObject resultJson = JSONObject.parseObject((String)((String)forEntity.getBody()));
        if (resultJson.getBoolean("success").booleanValue()) {
            return (ZlbUserInfo)JSONObject.parseObject((String)resultJson.getString("data"), ZlbUserInfo.class);
        }
        return null;
    }

    @Override
    public ZlbUserInfo getZlbUserInfo(String ticket, String appId) {
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55-\u7968\u636e\u8ba4\u8bc1\u83b7\u53d6token");
        String token = this.getClientTicketCode(ticket, this.appKey, this.appSecret, appId);
        if (StrUtil.isBlank((CharSequence)token)) {
            log.error("\u6d59\u91cc\u529e\u767b\u5f55-\u7968\u636e\u8ba4\u8bc1\u83b7\u53d6token\u5931\u8d25, ticket:{}, appid:{}", (Object)StrUtil.sub((CharSequence)ticket, (int)0, (int)10), (Object)appId);
            return null;
        }
        ZlbUserInfo clientInfoByToken = this.getClientInfoByToken(token, this.appKey, this.appSecret);
        if (Objects.isNull(clientInfoByToken)) {
            log.error("\u6d59\u91cc\u529e\u767b\u5f55-\u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25, ticket:{}, appid{}", (Object)StrUtil.sub((CharSequence)ticket, (int)0, (int)10), (Object)appId);
            return null;
        }
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JsonUtils.toJsonString((Object)clientInfoByToken));
        return clientInfoByToken;
    }

    @Generated
    public ZlbClientServiceService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

