/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.service.redis;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class RedisLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisLimiter.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public void limitWait(String key, int limitCount, int limitSecond) {
        boolean ok;
        do {
            Long ttl;
            ok = this.limit(key, limitCount, limitSecond);
            log.info("\u653e\u884c\u6807\u5fd7={}", (Object)ok);
            if (ok || null == (ttl = this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS)) || ttl <= 0L) continue;
            try {
                Thread.sleep(ttl);
                log.info("sleeped:{}", (Object)ttl);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException\uff1a", (Throwable)e);
            }
        } while (!ok);
    }

    public boolean limit(String key, int limitCount, int limitSecond) {
        List<String> keys = Collections.singletonList(key);
        String luaScript = this.buildLuaScript();
        DefaultRedisScript redisScript = new DefaultRedisScript(luaScript, Number.class);
        Number count = (Number)this.redisTemplate.execute((RedisScript)redisScript, keys, new Object[]{limitCount, limitSecond});
        log.info("Access try count is {} for key = {}", (Object)count, (Object)key);
        return count != null && count.intValue() <= limitCount;
    }

    public String buildLuaScript() {
        StringBuilder lua = new StringBuilder();
        lua.append("local c");
        lua.append("nc = redis.call('get',KEYS[1])");
        lua.append("nif c and tonumber(c) > tonumber(ARGV[1]) then");
        lua.append("nreturn c;");
        lua.append("nend");
        lua.append("nc = redis.call('incr',KEYS[1])");
        lua.append("nif tonumber(c) == 1 then");
        lua.append("nredis.call('expire',KEYS[1],ARGV[2])");
        lua.append("nend");
        lua.append("nreturn c;");
        return lua.toString();
    }
}

