/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.service;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.question.param.ExamRecordsSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.SubmitExamParam;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperResultVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamRecordVo;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.enums.CourseTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.MaintainBeforeExamParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseItemManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingIndustryVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExamService {
    @DubboReference
    private ITrainingProviderService trainingProviderService;
    @DubboReference
    private ITuCourseProviderService tuCourseProviderService;
    @DubboReference
    private ITrainingCourseProviderService trainingCourseProviderService;
    @DubboReference
    private ICourseItemManagerProviderService courseItemManagerProviderService;
    @DubboReference
    private ITuPaperProviderService tuPaperProviderService;
    @DubboReference
    private IPaperStructureProviderService paperStructureProviderService;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;

    public LayuiGridData<ExamRecordVo> getExamRecords(ExamRecordsSearchParam param) {
        TrainingDetailVo training = this.trainingProviderService.getTrainingInfo(param.getTid());
        if (training != null && training.getTestMode() != null) {
            param.setTestMode(Integer.valueOf(training.getTestMode().intValue()));
        }
        return this.tuPaperProviderService.getExamRecords(param);
    }

    @Transactional
    public ExamPaperDataVo getExamQuestions(StartExamParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tuCourseId", "tid"});
        TuCourse tuCourse = this.tuCourseProviderService.getTuCourseInfoById(param.getTuCourseId());
        if (tuCourse == null) {
            throw new ServiceException("\u672a\u627e\u5230\u8be5\u5b66\u4e60\u8bfe\u7a0b\uff01");
        }
        TrainingDetailVo training = this.trainingProviderService.getTrainingInfo(param.getTid());
        if (training.getTrainEndTime().before(new Date())) {
            throw new ServiceException("\u57f9\u8bad\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff01");
        }
        param.setTestMode(Integer.valueOf(0));
        param.setTrainMode(training.getTrainMode());
        param.setTrainTarget(training.getTrainTarget());
        param.setEnrollDetailId(tuCourse.getEnrollDetailId());
        param.setCourseIdList(new ArrayList<String>(Collections.singletonList(tuCourse.getCourseItemId().toString())));
        param.setTestPaperUsage(Integer.valueOf(training.getTestPaperUsage().intValue()));
        param = Objects.equals(training.getTrainTarget(), TrainTargetEnum.UNIT.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_WORK.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_MANGER.getValue()) ? this.initializeExamParamForUnit(param, tuCourse) : this.initializeExamParamForOrig(param, tuCourse);
        if (tuCourse.getIsPassed() == 1) {
            param.setRetestSetting(Integer.valueOf(training.getRetestSetting().intValue()));
            return this.tuPaperProviderService.getReExamQuestions(param);
        }
        ExamPaperDataVo examPaper = this.tuPaperProviderService.getExamQuestions(param);
        if (examPaper != null && Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_WORK.getValue())) {
            this.tuEnrollProviderService.maintainBeforeExam(new MaintainBeforeExamParam(param.getEnrollDetailId(), new Date()));
        }
        return examPaper;
    }

    public StartExamParam initializeExamParamForUnit(StartExamParam param, TuCourse tuCourse) {
        if (param.getTrainMode() == 0) {
            TrainingCourse trainingCourse = this.trainingCourseProviderService.getById(tuCourse.getTrainingCourseId());
            param.setPaperStructureId(trainingCourse.getPaperStructureId());
            param.setPassScore(Integer.valueOf(String.valueOf(trainingCourse.getPassingScore())));
            param.setCourseId(trainingCourse.getCourseId());
            param.setWay(trainingCourse.getWay());
            param.setSingleNum(trainingCourse.getSingleNum());
            param.setMultipleNum(trainingCourse.getMultipleNum());
            param.setCompletionNum(trainingCourse.getCompletionNum());
            param.setJudgeNum(trainingCourse.getJudgeNum());
            param.setSingleScore(trainingCourse.getSingleScore());
            param.setMultipleScore(trainingCourse.getMultipleScore());
            param.setCompletionScore(trainingCourse.getCompletionScore());
            param.setJudgeScore(trainingCourse.getJudgeScore());
            param.setTotalScore(trainingCourse.getTotalScore());
            if (trainingCourse.getCourseType() == CourseTypeEnum.GENERAL.getValue()) {
                param.setIndustryCodes(new ArrayList<String>(Arrays.asList("0")));
                param.setRiskFactorCodes(new ArrayList<String>(Arrays.asList("0")));
                param.setPersonTypeCodes(new ArrayList<String>(Arrays.asList("200001", "200002")));
            } else {
                param.setIndustryCodes(Arrays.asList(trainingCourse.getIndustry().split(",")));
                param.setRiskFactorCodes(Arrays.asList(trainingCourse.getRiskFactor().split(",")));
                param.setPersonTypeCodes(Arrays.asList(trainingCourse.getPersonTypeCode().split(",")));
            }
        }
        if (param.getTrainMode() == 1) {
            param.setPaperStructureId(tuCourse.getPaperStructureId());
            param.setPassScore(Integer.valueOf((int)((double)tuCourse.getTotalScore().intValue() * 0.6)));
            param.setCourseId(tuCourse.getCourseItemId());
            param.setWay(Long.valueOf(tuCourse.getWay().intValue()));
            param.setSingleNum(tuCourse.getSingleNum());
            param.setMultipleNum(tuCourse.getMultipleNum());
            param.setCompletionNum(tuCourse.getCompletionNum());
            param.setJudgeNum(tuCourse.getJudgeNum());
            param.setSingleScore(tuCourse.getSingleScore());
            param.setMultipleScore(tuCourse.getMultipleScore());
            param.setCompletionScore(tuCourse.getCompletionScore());
            param.setJudgeScore(tuCourse.getJudgeScore());
            param.setTotalScore(tuCourse.getTotalScore());
            if (tuCourse.getCourseType() == CourseTypeEnum.GENERAL.getValue()) {
                param.setIndustryCodes(new ArrayList<String>(Arrays.asList("0")));
                param.setRiskFactorCodes(new ArrayList<String>(Arrays.asList("0")));
                param.setPersonTypeCodes(new ArrayList<String>(Arrays.asList("200001", "200002")));
            } else {
                param.setIndustryCodes(Arrays.asList(tuCourse.getIndustry().split(",")));
                param.setRiskFactorCodes(Arrays.asList(tuCourse.getRiskFactor().split(",")));
                param.setPersonTypeCodes(Arrays.asList(tuCourse.getPersonType().split(",")));
            }
        }
        return param;
    }

    public StartExamParam initializeExamParamForOrig(StartExamParam param, TuCourse tuCourse) {
        param.setPaperStructureId(tuCourse.getPaperStructureId());
        param.setPassScore(Integer.valueOf((int)((double)tuCourse.getTotalScore().intValue() * 0.6)));
        param.setCourseId(tuCourse.getCourseItemId());
        param.setWay(Long.valueOf(tuCourse.getWay().intValue()));
        param.setSingleNum(tuCourse.getSingleNum());
        param.setMultipleNum(tuCourse.getMultipleNum());
        param.setCompletionNum(tuCourse.getCompletionNum());
        param.setJudgeNum(tuCourse.getJudgeNum());
        param.setSingleScore(tuCourse.getSingleScore());
        param.setMultipleScore(tuCourse.getMultipleScore());
        param.setCompletionScore(tuCourse.getCompletionScore());
        param.setJudgeScore(tuCourse.getJudgeScore());
        param.setTotalScore(tuCourse.getTotalScore());
        if (tuCourse.getCourseType() == CourseTypeEnum.GENERAL.getValue()) {
            param.setIndustryCodes(new ArrayList<String>(Arrays.asList("0")));
            param.setRiskFactorCodes(new ArrayList<String>(Arrays.asList("0")));
            param.setPersonTypeCodes(new ArrayList<String>(Arrays.asList("200001", "200002")));
        } else {
            param.setIndustryCodes(Arrays.asList(tuCourse.getIndustry().split(",")));
            param.setRiskFactorCodes(Arrays.asList(tuCourse.getRiskFactor().split(",")));
            param.setPersonTypeCodes(Arrays.asList(tuCourse.getPersonType().split(",")));
        }
        return param;
    }

    public ExamPaperDataVo getCentralizedExamQuestions(StartExamParam param) {
        TrainingDetailVo training = this.trainingProviderService.getTrainingInfo(param.getTid());
        param.setTrainTarget(training.getTrainTarget());
        param.setTrainMode(training.getTrainMode());
        TuEnrollDetail enrollDetail = this.tuEnrollProviderService.getEnrollDetailById(param.getEnrollDetailId());
        if (enrollDetail.getStudiedProgress() < enrollDetail.getStudyProgressTotal()) {
            throw new ServiceException("\u672a\u5b8c\u6210\u5b66\u4e60\uff0c\u65e0\u6cd5\u8003\u8bd5\uff01");
        }
        if (Objects.equals(training.getTrainTarget(), TrainTargetEnum.UNIT.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_WORK.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_MANGER.getValue())) {
            return this.centralizedExamQuestionsForUnit(param, training, enrollDetail);
        }
        return this.centralizedExamQuestionsForOrig(param, training);
    }

    @Transactional
    public ExamPaperDataVo centralizedExamQuestionsForUnit(StartExamParam param, TrainingDetailVo training, TuEnrollDetail enrollDetail) {
        List courseIdList = null;
        List riskFactorList = null;
        if (param.getTrainMode() == TrainingModeEnum.MARJOR.getValue()) {
            courseIdList = this.trainingCourseProviderService.getCourseIdListByTid(param.getTid());
            riskFactorList = this.trainingCourseProviderService.getRiskFactorListByTid(param.getTid());
            TrainingCourse trainingCourse = this.trainingCourseProviderService.getPaperInfoByTid(param.getTid());
            param.setWay(trainingCourse.getWay());
            param.setSingleNum(trainingCourse.getSingleNum());
            param.setMultipleNum(trainingCourse.getMultipleNum());
            param.setCompletionNum(trainingCourse.getCompletionNum());
            param.setJudgeNum(trainingCourse.getJudgeNum());
            param.setSingleScore(trainingCourse.getSingleScore());
            param.setMultipleScore(trainingCourse.getMultipleScore());
            param.setCompletionScore(trainingCourse.getCompletionScore());
            param.setJudgeScore(trainingCourse.getJudgeScore());
            param.setTotalScore(trainingCourse.getTotalScore());
        }
        if (param.getTrainMode() == TrainingModeEnum.PRECISE.getValue()) {
            if (enrollDetail == null || enrollDetail.getStudiedProgress() < enrollDetail.getStudyProgressTotal() && enrollDetail.getStudiedClassHour() < enrollDetail.getPassClassHour() && enrollDetail.getStudiedClassHour() < enrollDetail.getClassHourTotal()) {
                throw new ServiceException("\u8bf7\u5b8c\u6210\u5b66\u4e60\u540e\u518d\u8fdb\u884c\u8003\u8bd5\uff01");
            }
            courseIdList = this.tuCourseProviderService.getCourseIdListByTAU(param.getTid(), param.getUserId());
            riskFactorList = this.tuCourseProviderService.getRiskFactorListByTAU(param.getTid(), param.getUserId());
            param.setWay(training.getWay());
            param.setSingleNum(training.getSingleNum());
            param.setMultipleNum(training.getMultipleNum());
            param.setCompletionNum(training.getCompletionNum());
            param.setJudgeNum(training.getJudgeNum());
            param.setSingleScore(training.getSingleScore());
            param.setMultipleScore(training.getMultipleScore());
            param.setCompletionScore(training.getCompletionScore());
            param.setJudgeScore(training.getJudgeScore());
            param.setTotalScore(training.getTotalScore());
        }
        List industryCodeList = training.getTrainIndustryVoList().stream().map(TrainingIndustryVo::getIndustryCode).collect(Collectors.toList());
        List personTypeCodeList = training.getPersonCertificateList().stream().map(v -> "" + v.getPersonType()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)riskFactorList)) {
            throw new ServiceException("\u672a\u627e\u5230\u8be5\u57f9\u8bad\u8bfe\u7a0b\u7684\u5371\u5bb3\u56e0\u7d20\uff01");
        }
        param.setCourseIdList(courseIdList);
        param.setPersonTypeCodes(personTypeCodeList);
        param.setRiskFactorCodes(riskFactorList);
        param.setIndustryCodes(industryCodeList);
        param.setTestMode(Integer.valueOf(1));
        param.setRetestSetting(Integer.valueOf(training.getRetestSetting().intValue()));
        param.setPaperStructureId(training.getPaperStructureId());
        param.setTestPaperUsage(Integer.valueOf(training.getTestPaperUsage().intValue()));
        param.setPassScore(training.getPassingScore());
        if (enrollDetail.getTestStatus() == 1) {
            return this.tuPaperProviderService.getReExamQuestions(param);
        }
        ExamPaperDataVo examPaper = this.tuPaperProviderService.getExamQuestions(param);
        if (examPaper != null && Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_WORK.getValue())) {
            this.tuEnrollProviderService.maintainBeforeExam(new MaintainBeforeExamParam(param.getEnrollDetailId(), new Date()));
        }
        return examPaper;
    }

    public ExamPaperDataVo centralizedExamQuestionsForOrig(StartExamParam param, TrainingDetailVo training) {
        List personTypeCodeList = training.getPersonCertificateList().stream().map(v -> "" + v.getPersonType()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personTypeCodeList)) {
            throw new ServiceException("\u672a\u627e\u5230\u8be5\u57f9\u8bad\u8bfe\u7a0b\u7684\u4eba\u5458\u7c7b\u578b\uff01");
        }
        List courseIdList = this.tuCourseProviderService.getCourseIdListByTAU(param.getTid(), param.getUserId());
        param.setWay(training.getWay());
        param.setSingleNum(training.getSingleNum());
        param.setMultipleNum(training.getMultipleNum());
        param.setCompletionNum(training.getCompletionNum());
        param.setJudgeNum(training.getJudgeNum());
        param.setSingleScore(training.getSingleScore());
        param.setMultipleScore(training.getMultipleScore());
        param.setCompletionScore(training.getCompletionScore());
        param.setJudgeScore(training.getJudgeScore());
        param.setTotalScore(training.getTotalScore());
        param.setCourseIdList(courseIdList);
        param.setPersonTypeCodes(personTypeCodeList);
        param.setTestMode(Integer.valueOf(1));
        param.setRetestSetting(Integer.valueOf(training.getRetestSetting().intValue()));
        param.setPaperStructureId(training.getPaperStructureId());
        param.setTestPaperUsage(Integer.valueOf(training.getTestPaperUsage().intValue()));
        param.setPassScore(training.getPassingScore());
        if (param.getReTest().booleanValue()) {
            return this.tuPaperProviderService.getReExamQuestions(param);
        }
        return this.tuPaperProviderService.getExamQuestions(param);
    }

    public ExamPaperDataVo getReExamQuestions(StartExamParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tuCourseId"});
        TuCourse tuCourse = this.tuCourseProviderService.getTuCourseInfoById(param.getTuCourseId());
        if (tuCourse == null) {
            throw new ServiceException("\u672a\u627e\u5230\u8be5\u5b66\u4e60\u8bfe\u7a0b\uff01");
        }
        if (tuCourse.getRetestLimit() == 0) {
            throw new ServiceException("\u91cd\u8003\u6b21\u6570\u5df2\u7528\u5c3d\uff01");
        }
        TrainingDetailVo training = this.trainingProviderService.getTrainingInfo(param.getTid());
        if (training.getTrainEndTime().before(new Date())) {
            throw new ServiceException("\u57f9\u8bad\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff01");
        }
        CourseItemVo courseItemVo = this.courseItemManagerProviderService.getByTrainCourseId(tuCourse.getTrainingCourseId());
        TrainingCourse trainingCourse = this.trainingCourseProviderService.getById(tuCourse.getTrainingCourseId());
        param.setTid(param.getTid());
        param.setEnrollDetailId(tuCourse.getEnrollDetailId());
        param.setWorkTypes(courseItemVo.getCourseItemWorkTypeList().stream().map(v -> v.getWorkTypeCode()).collect(Collectors.toList()));
        param.setPaperStructureId(courseItemVo.getPaperStructureId());
        param.setTestPaperUsage(Integer.valueOf(training.getTestPaperUsage().intValue()));
        param.setRetestSetting(Integer.valueOf(training.getRetestSetting().intValue()));
        param.setPassScore(Integer.valueOf(String.valueOf(trainingCourse.getPassingScore())));
        param.setCourseId(trainingCourse.getCourseId());
        param.setWay(trainingCourse.getWay());
        param.setSingleNum(trainingCourse.getSingleNum());
        param.setMultipleNum(trainingCourse.getMultipleNum());
        param.setCompletionNum(trainingCourse.getCompletionNum());
        param.setJudgeNum(trainingCourse.getJudgeNum());
        param.setSingleScore(trainingCourse.getSingleScore());
        param.setMultipleScore(trainingCourse.getMultipleScore());
        param.setCompletionScore(trainingCourse.getCompletionScore());
        param.setJudgeScore(trainingCourse.getJudgeScore());
        param.setTotalScore(trainingCourse.getTotalScore());
        return this.tuPaperProviderService.getReExamQuestions(param);
    }

    public ExamPaperResultVo submitExam(SubmitExamParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tuPaperId", "timeCost", "paperStructureId"});
        TuEnrollDetail enrollDetail = this.tuEnrollProviderService.getEnrollDetailById(param.getTuEnrollDetailId());
        TrainingDetailVo trainInfo = this.trainingProviderService.getTrainingInfo(enrollDetail.getTid());
        if (trainInfo.getTrainTarget() == TrainTargetEnum.UNIT.getValue() || trainInfo.getTrainTarget() == TrainTargetEnum.RAY_MANGER.getValue() || trainInfo.getTrainTarget() == TrainTargetEnum.RAY_WORK.getValue()) {
            return this.submitForUnit(param, trainInfo, enrollDetail);
        }
        return this.submitForOrig(param, trainInfo, enrollDetail);
    }

    public ExamPaperResultVo submitForUnit(SubmitExamParam param, TrainingDetailVo trainInfo, TuEnrollDetail enrollDetail) {
        TrainingCourse paperInfo = new TrainingCourse();
        if (trainInfo.getTrainMode() == 1) {
            if (trainInfo.getTestMode() == 0) {
                tuCourse = this.tuCourseProviderService.getById(param.getTuCourseId());
                param.setSingleScore(tuCourse.getSingleScore());
                param.setMultipleScore(tuCourse.getMultipleScore());
                param.setCompletionScore(tuCourse.getCompletionScore());
                param.setJudgeScore(tuCourse.getJudgeScore());
            } else {
                param.setSingleScore(trainInfo.getSingleScore());
                param.setMultipleScore(trainInfo.getMultipleScore());
                param.setCompletionScore(trainInfo.getCompletionScore());
                param.setJudgeScore(trainInfo.getJudgeScore());
            }
        } else {
            if (trainInfo.getTestMode() == 0) {
                tuCourse = this.tuCourseProviderService.getById(param.getTuCourseId());
                paperInfo = this.trainingCourseProviderService.getById(tuCourse.getTrainingCourseId());
            } else {
                paperInfo = this.trainingCourseProviderService.getPaperInfoByTid(enrollDetail.getTid());
            }
            param.setSingleScore(paperInfo.getSingleScore());
            param.setMultipleScore(paperInfo.getMultipleScore());
            param.setCompletionScore(paperInfo.getCompletionScore());
            param.setJudgeScore(paperInfo.getJudgeScore());
        }
        ExamPaperResultVo resultVo = this.tuPaperProviderService.submitExam(param);
        if (resultVo.getTestMode() == 1) {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tuEnrollDetailId"});
            this.tuCourseProviderService.updateCentralizedExamResult(param.getTuEnrollDetailId(), resultVo.getResultValue());
        }
        if (resultVo.getTestMode() == 0) {
            this.tuCourseProviderService.updateExamResult(param.getTuCourseId(), resultVo.getResultValue(), resultVo.getPassTimes(), resultVo.getScore().intValue(), trainInfo.getTrainMode());
        }
        return resultVo;
    }

    public ExamPaperResultVo submitForOrig(SubmitExamParam param, TrainingDetailVo trainInfo, TuEnrollDetail enrollDetail) {
        if (trainInfo.getTestMode() == 0) {
            TuCourse tuCourse = this.tuCourseProviderService.getById(param.getTuCourseId());
            param.setSingleScore(tuCourse.getSingleScore());
            param.setMultipleScore(tuCourse.getMultipleScore());
            param.setCompletionScore(tuCourse.getCompletionScore());
        } else {
            param.setSingleScore(trainInfo.getSingleScore());
            param.setMultipleScore(trainInfo.getMultipleScore());
            param.setCompletionScore(trainInfo.getCompletionScore());
        }
        ExamPaperResultVo resultVo = this.tuPaperProviderService.submitExam(param);
        if (resultVo.getTestMode() == 1) {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tuEnrollDetailId"});
            this.tuCourseProviderService.updateCentralizedExamResult(param.getTuEnrollDetailId(), resultVo.getResultValue());
        }
        if (resultVo.getTestMode() == 0) {
            this.tuCourseProviderService.updateExamResult(param.getTuCourseId(), resultVo.getResultValue(), resultVo.getPassTimes(), resultVo.getScore().intValue(), trainInfo.getTrainMode());
        }
        return resultVo;
    }

    public ExamPaperResultVo getCourseExamDetail(Long id) {
        return this.tuPaperProviderService.getCourseExamDetail(id);
    }
}

