/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.uc;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.uploader.FileMD5;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.core.framework.utils.VideoUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.training.param.TuCertificateModel;
import cn.smarthse.radiationTraining.modules.training.param.training.MyCertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ITuCertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertTrainVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.MyCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myCertificates"})
public class MyCertificatesController
extends ControllerSupport {
    private static final String UPLOADDIR = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.Common.getPath();
    @DubboReference
    private ITuCertificateProviderService tuCertificateProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    private final OssClientBean ossClientBean;

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<MyCertificateVo>> getList(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateList(param));
    }

    @GetMapping(value={"/getList/count"})
    public ResponseData<CertTrainVo> getListCount(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateListCount(param));
    }

    @PostMapping(value={"/addCertificate"})
    public ResponseData addCertificate(@RequestBody IdParam idParam) {
        this.tuCertificateProviderService.addCertificate(idParam.getId());
        return ResponseData.success();
    }

    @GetMapping(value={"getDetailById"})
    public ResponseData<TuCertVo> getDetail(Long id) {
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateDetailById(id, ShiroUtil.getLoginUserId()));
    }

    @GetMapping(value={"/getHasCetTrainList"})
    public ResponseData<LayuiGridData<CertTrainVo>> getHasCetTrainList(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getHasCetTrainList(param));
    }

    @GetMapping(value={"/getTrainCetList"})
    public ResponseData<List<MyCertificateVo>> getTrainCetList(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getTrainCetList(param));
    }

    @RequestLimit(second=300, maxCount=1, msg="\u8bf75\u5206\u949f\u540e\u91cd\u8bd5\uff01")
    @GetMapping(value={"/generateCertificate"})
    public ResponseData<TuCertVo> generateCertificate(Long id) {
        return ResponseData.success((Object)this.tuCertificateProviderService.genCertFile(id));
    }

    @RequestLimit(second=300, maxCount=1, msg="\u8bf75\u5206\u949f\u540e\u91cd\u8bd5\uff01")
    @GetMapping(value={"/SendCertificate"})
    public ResponseData SendCertificate(Long id) {
        this.tuCertificateProviderService.SendCertificate(id);
        return ResponseData.success();
    }

    private void checkCertificateInfo(TuCertificateModel model) {
        if (StringUtils.isEmpty((CharSequence)model.getTrainingName())) {
            throw new ServiceException("\u7f3a\u5c11\u57f9\u8bad\u540d\u79f0\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53bb\u5b8c\u5584");
        }
        if (StringUtils.isEmpty((CharSequence)model.getName())) {
            throw new ServiceException("\u7f3a\u5c11\u59d3\u540d\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getSex())) {
            throw new ServiceException("\u7f3a\u5c11\u6027\u522b\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getIdcard())) {
            throw new ServiceException("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getEducation())) {
            throw new ServiceException("\u7f3a\u5c11\u6559\u80b2\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getImg())) {
            throw new ServiceException("\u7f3a\u5c11\u56fe\u7247\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getImg2())) {
            throw new ServiceException("\u7f3a\u5c11\u516c\u7ae0\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53bb\u5b8c\u5584");
        }
        if (StringUtils.isEmpty((CharSequence)model.getWorkUnit())) {
            throw new ServiceException("\u7f3a\u5c11\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getTrainingName())) {
            throw new ServiceException("\u7f3a\u5c11\u57f9\u8bad\u5185\u5bb9\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53bb\u5b8c\u5584");
        }
        if (StringUtils.isEmpty((CharSequence)model.getScore())) {
            throw new ServiceException("\u7f3a\u5c11\u8003\u8bd5\u6210\u7ee9\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getRadiationWork())) {
            throw new ServiceException("\u7f3a\u5c11\u5de5\u4f5c\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getOccExposureCode())) {
            throw new ServiceException("\u7f3a\u5c11\u804c\u4e1a\u7167\u5c04\u4ee3\u7801\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getWorkBeginTime())) {
            throw new ServiceException("\u7f3a\u5c11\u653e\u5c04\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getTrainingName())) {
            throw new ServiceException("\u7f3a\u5c11\u57f9\u8bad\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u57f9\u8bad\u5355\u4f4d\u5b8c\u5584\u4fe1\u606f");
        }
        if (!VideoUtils.isImagesTrue((String)model.getImg()).booleanValue()) {
            throw new ServiceException("\u8bc1\u4ef6\u7167\u5931\u6548\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!VideoUtils.isImagesTrue((String)model.getImg2()).booleanValue()) {
            throw new ServiceException("\u516c\u7ae0\u7167\u5931\u6548\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
    }

    SysFileModel uploadBackstage(HttpServletRequest request, File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), (InputStream)inputStream);
        String uploadDir = UPLOADDIR.replace("\\", "/");
        int fileResource = FileResourceEnum.radiation_training.getValue();
        String hashCode = FileMD5.getFileMD5((byte[])multipartFile.getBytes());
        String originalFilename = multipartFile.getName();
        String fileExt = FilenameUtils.getExtension((String)multipartFile.getName());
        Long filesize = multipartFile.getSize();
        String fileName = file.getPath().substring(file.getPath().lastIndexOf("\\") + 1);
        fileName = FileUploadSimple.getNumberName((String)fileName, (String)fileExt);
        String ip = ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        String ossUrl = null;
        if (this.ossClientBean.isAsynch()) {
            String fullname = StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)originalFilename)) ? originalFilename + "." + fileExt : originalFilename;
            ossUrl = this.ossClientBean.OSSPutObject(fileName, file, uploadDir, fullname);
            this.logger.info("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + this.ossClientBean.getUrl(ossUrl));
        }
        SysFileModel sysFileModel = new SysFileModel();
        sysFileModel.setResource(Integer.valueOf(fileResource)).setFileName(originalFilename).setFileSize("" + filesize).setFileExt(fileExt).setFileHash(hashCode).setCreatorIp(ip).setFullOssUrl(this.ossClientBean.getUrl(ossUrl)).setOssUrl(ossUrl);
        this.sysFileProvideService.addSysFile(sysFileModel, ShiroUtil.getLoginUserId());
        ((InputStream)inputStream).close();
        return sysFileModel;
    }

    @Generated
    public MyCertificatesController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

