/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.uc;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.enums.sys.MsgTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.sys.MsgQueryParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IMsgProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg"})
@Validated
public class MsgController {
    @DubboReference
    private IMsgProviderService msgService;

    @GetMapping(value={"/getMsgList"})
    public ResponseData<LayuiGridData<MsgVo>> getMsgList(MsgQueryParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return ResponseData.success((Object)this.msgService.getMsgList(param));
    }

    @PostMapping(value={"readMsg"})
    public ResponseData<String> readMsg(@RequestBody IdsParam param) {
        this.msgService.readMsg(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @PostMapping(value={"delMsg"})
    public ResponseData<String> delMsg(@RequestBody IdsParam param) {
        this.msgService.del(param.getIdList(), param.getLoginUserId());
        return ResponseData.success();
    }

    @PostMapping(value={"getMsgTypeList"})
    public ResponseData<List<MsgTypeEnum>> getMsgTypeList() {
        ResponseData data = new ResponseData();
        data.setResult(Arrays.asList(MsgTypeEnum.values()));
        return data;
    }

    @Generated
    public MsgController() {
    }
}

