/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.trainingCenter;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RemoveEnrollInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ITuCertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.MyCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxCompanyListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxTrainCourseGroupVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train"})
public class WxTrainingController
extends ControllerSupport {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser iTrainingProviderServiceForUser;
    @DubboReference
    private ITuCertificateProviderService tuCertificateProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;

    @PostMapping(value={"/qrcode/analysis"})
    public ResponseData parsingQRCode(String qrcode) {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)this.enrollProviderService.parsingQRCode(qrcode));
    }

    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<UserMyTrainListVo>> getTrainingList(UserMyTrainSearchParam param) {
        ShiroPrincipal shiroPrincipal = ShiroUtil.getShiroPrincipal();
        param.setUid(shiroPrincipal.getUserId());
        param.setIsGetBackTrain(Integer.valueOf(1));
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainPageListForUser(param));
    }

    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<TrainingBaseInfoVo> getMyTrainingBaseInfo(Long tid, Long enrollDetailId) {
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainingBaseInfoForWx(tid, uid, enrollDetailId));
    }

    @GetMapping(value={"getEnrollNeededInfo"})
    public ResponseData<TrainingBaseInfoVo> getEnrollNeededInfo(Long tid) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getEnrollNeededInfo(tid));
    }

    @GetMapping(value={"searchCompanyList"})
    public ResponseData<LayuiGridData<WxCompanyListVo>> searchCompanyList(String companyName, Integer pageNum, Integer pageSize) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.searchCompanyList(ShiroUtil.getLoginUserId(), companyName, pageNum, pageSize));
    }

    @GetMapping(value={"searchCompanyListForRho"})
    public ResponseData<LayuiGridData<WxCompanyListVo>> searchCompanyListForRho(String companyName, Integer pageNum, Integer pageSize) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.searchCompanyListForRho(ShiroUtil.getLoginUserId(), companyName, pageNum, pageSize));
    }

    @GetMapping(value={"isCouldEnroll"})
    public ResponseData<Boolean> isCouldEnroll(TrainingSearchParam param) {
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.isCouldEnroll(param));
    }

    @GetMapping(value={"getCouldEnrollList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getCouldEnrollList(TrainingSearchParam param) {
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getCouldEnrollList(param));
    }

    @GetMapping(value={"getCouldEnrollInfo"})
    public ResponseData<TrainingListVo> getCouldEnrollInfo(TrainingSearchParam param) {
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getCouldEnrollInfo(param));
    }

    @GetMapping(value={"getTrainCourseList"})
    public ResponseData<List<WxTrainCourseGroupVo>> getTrainCourseListForWx(Long tid) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainCourseListForWx(tid));
    }

    @GetMapping(value={"getCertList"})
    public ResponseData<List<MyCertificateVo>> getCertList(Long id) {
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateList(id));
    }

    @GetMapping(value={"getBaseCourseCataLogue"})
    public ResponseData<List<CourseGroupCatalogueVo>> getBaseCourseCataLogue(Long id) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getBaseCourseCataLogue(id));
    }

    @Log(title="\u4e2a\u4eba\u7528\u6237\u5217\u8868-\u5220\u9664\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_person, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"staffToRmEnrollInfo"})
    public ResponseData staffToRmEnrollInfo(RemoveEnrollInfoParam param) {
        this.enrollProviderService.staffToRmEnrollInfo(param);
        return ResponseData.success();
    }

    @GetMapping(value={"reBuildAllRelationship"})
    public ResponseData getTrainingList(String pwd) {
        this.enrollProviderService.reBuildAllRelationship(pwd);
        return ResponseData.success();
    }

    @PostMapping(value={"/backup/sync"})
    public ResponseData test(Date time, String pwd) {
        if (!"asdfjijzjwmw".equals(pwd)) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.hseCompanyProviderService.updateNewestInfoFromSource(time);
        return ResponseData.success();
    }

    @GetMapping(value={"/updateTime/set"})
    public ResponseData setUpdateTime(Date unitTime, Date ogrTime, String pwd) {
        if (!"asdfjijzjwmw".equals(pwd)) {
            throw new ServiceException("\u5f02\u5e38");
        }
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.redisTemplate.opsForValue().set((Object)RedisKey.getUpUnitTimeKey(), (Object)dateformat.format(unitTime));
        this.redisTemplate.opsForValue().set((Object)RedisKey.getUpOrgTimeKey(), (Object)dateformat.format(ogrTime));
        return ResponseData.success();
    }
}

