/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.trainingCenter;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RestoreStuRecordParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.ExamAlertInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TraningProgressVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/learn"})
public class WxCourseController {
    @DubboReference
    private ITuCourseProviderService tuCourseProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser iTrainingProviderServiceForUser;

    @PostMapping(value={"updateStuDuration", "updateStuDuration/major", "updateDuration/precise", "updateStuDuration/org"})
    @RequestLimit(second=15, maxCount=1, expression="#param.tuCourseId")
    public ResponseData updateStuDuration(@RequestBody UpdateDurationParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        this.tuCourseProviderService.updateStuDuration(param);
        return ResponseData.success((String)"\u6210\u529f");
    }

    @GetMapping(value={"getCourseCataLogue"})
    public ResponseData<List<CourseGroupCatalogueVo>> getCourseCataLogueForMajor(Long tid, Long detailId, Integer stuStatus) {
        this.tuCourseProviderService.checkOwner(detailId, null, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getCourseCataLogueForMajor(tid, detailId, stuStatus, ShiroUtil.getLoginUserId()));
    }

    @GetMapping(value={"getCourseCataLogueForPrecise"})
    public ResponseData<List<CourseItemCatalogueVo>> getCourseCataLogueForPrecise(Long enrollDetailId, Integer stuStatus) {
        this.tuCourseProviderService.checkOwner(enrollDetailId, null, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getCourseCataLogueForPrecise(enrollDetailId, stuStatus));
    }

    @GetMapping(value={"getCourseCataLogueForOrg"})
    public ResponseData<List<CourseItemCatalogueVo>> getCourseCataLogueForOrg(Long tid, Long enrollDetailId, Integer stuStatus) {
        this.tuCourseProviderService.checkOwner(enrollDetailId, null, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getCourseCataLogueForOrg(tid, enrollDetailId, stuStatus));
    }

    @GetMapping(value={"getCourseItem2"})
    public ResponseData<TrainingCourseItemVo> getCourseItem(Long tuCoruseId) {
        this.tuCourseProviderService.checkOwner(null, tuCoruseId, ShiroUtil.getLoginUserId());
        ResponseData responseData = this.iTrainingProviderServiceForUser.getCourseItem(tuCoruseId);
        TrainingCourseItemVo result = (TrainingCourseItemVo)responseData.getResult();
        if (result != null && result.getVideoDurationSec() != null && result.getStuStatus() != null && result.getStuStatus().equals(2)) {
            result.setStuDurationSec(result.getVideoDurationSec());
        }
        return responseData;
    }

    @GetMapping(value={"getCourseItem"})
    public ResponseData<TrainingCourseItemVo> getCourseItemForMajor(Long traningCourseId, Long tuCoruseId) {
        this.tuCourseProviderService.checkOwner(null, tuCoruseId, ShiroUtil.getLoginUserId());
        return this.iTrainingProviderServiceForUser.getCourseItemDetailForMajor(traningCourseId, tuCoruseId);
    }

    @GetMapping(value={"getCourseItemForPrecise"})
    public ResponseData<TrainingCourseItemVo> getCourseItemForPrecise(Long tuCoruseId) {
        this.tuCourseProviderService.checkOwner(null, tuCoruseId, ShiroUtil.getLoginUserId());
        return this.iTrainingProviderServiceForUser.getCourseItemDetailForPrecise(tuCoruseId);
    }

    @RequestLimit(second=20, maxCount=1)
    @PostMapping(value={"restore"})
    public ResponseData restore(@RequestBody RestoreStuRecordParam param) {
        this.tuCourseProviderService.checkOwner(null, param.getTuCourseId(), ShiroUtil.getLoginUserId());
        this.tuCourseProviderService.restoreSingleness(param);
        return ResponseData.success();
    }

    @RequestLimit(second=20, maxCount=1)
    @PostMapping(value={"restoreAll"})
    public ResponseData restoreAll(@RequestBody RestoreStuRecordParam param) {
        this.tuCourseProviderService.checkOwner(param.getEnrollDetailId(), null, ShiroUtil.getLoginUserId());
        this.tuCourseProviderService.restoreAll(param);
        return ResponseData.success();
    }

    @GetMapping(value={"getTraningProgress"})
    public ResponseData<TraningProgressVo> getTraningProgress(Long tuEnrollDetailId) {
        TraningProgressVo vo = this.iTrainingProviderServiceForUser.getTraningProgress(tuEnrollDetailId);
        return ResponseData.success((Object)vo);
    }

    @GetMapping(value={"getExamAlertInfo"})
    public ResponseData<ExamAlertInfoVo> getExamAlertInfo(Long tuCourseId) {
        ExamAlertInfoVo vo = this.iTrainingProviderServiceForUser.getExamAlertInfo(tuCourseId);
        return ResponseData.success((Object)vo);
    }

    @GetMapping(value={"getFlunkedCourse", "getFlunkedCourseForPrecise", "getFlunkedCourseForOrg"})
    public ResponseData<List<CourseItemCatalogueVo>> getFlunkedCourse(Long tid, Long enrollDetailId) {
        return ResponseData.success((Object)this.tuCourseProviderService.getFlunkedCourse(tid, enrollDetailId));
    }

    @GetMapping(value={"test"})
    public ResponseData<String> syncTest(Long enrollDetailId) {
        this.tuCourseProviderService.syncEnrollInfo(enrollDetailId);
        return ResponseData.success();
    }
}

