/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.personalCenter;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.AcUserInfoParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.MdOldPsdParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVoH5;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.AcUserInfoVo;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.converter.H5Converter;
import cn.smarthse.radiationTraining.modules.wx.service.thrid.BaiduApiService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/personalCenter"})
@Validated
public class PersonalCenterController
extends ControllerSupport {
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;
    private final OssClientBean ossClientBean;
    private final BaiduApiService baiduApiService;
    private final H5Converter converter;

    @PostMapping(value={"/getPersonalInfo"})
    public ResponseData<PersonalUserVo> getPersonalInfo() {
        PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId());
        personalUserInfo.setIdcardTypeName(IdcardTypeEnum.getName((Integer)personalUserInfo.getIdcardType()));
        return ResponseData.success((Object)personalUserInfo);
    }

    @ApiEncrypt(response=true)
    @PostMapping(value={"/getAcInfo"})
    @Log(title="\u83b7\u53d6\u654f\u611f\u4fe1\u606f", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_view_user_sensitive_info)
    public ResponseData<AcUserInfoVo> getAcInfo(@RequestBody AcUserInfoParam param) {
        SysUser user = this.userProviderService.getFullUserInfoById(ShiroUtil.getLoginUserId());
        SysUserInfo sysUserInfo = user.getSysUserInfo();
        AcUserInfoVo vo = new AcUserInfoVo();
        if (param.getIncludeIdCard() == 1 && sysUserInfo != null) {
            vo.setIdCard(sysUserInfo.getIdcard());
        }
        if (param.getIncludeName() == 1 && user != null) {
            vo.setName(user.getName());
        }
        return ResponseData.success((Object)vo);
    }

    @PostMapping(value={"/getPersonalInfoH5"})
    public ResponseData<PersonalUserVoH5> getPersonalInfoH5() {
        PersonalUserVoH5 personalUserVoH5 = this.converter.PersonalUserVo2PersonalUserVoH5(this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId()));
        personalUserVoH5.setIdcardTypeName(IdcardTypeEnum.getName((Integer)personalUserVoH5.getIdcardType()));
        return ResponseData.success((Object)personalUserVoH5);
    }

    @PostMapping(value={"/editUser"})
    @RequestLimit(second=1, maxCount=1)
    @Log(title="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> editUser(@RequestBody EditUserParam editUserParam) {
        try {
            editUserParam.setId(ShiroUtil.getLoginUserId());
            this.userProviderService.editPersonal(editUserParam);
            return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            this.logger.error("DuplicateKeyException:", (Throwable)e);
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"/editUser/xh"})
    @RequestLimit(second=1, maxCount=1)
    @Log(title="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599(\u534f\u4f1a)", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> editXhUser(@RequestBody EditUserParam editUserParam) {
        try {
            editUserParam.setId(ShiroUtil.getLoginUserId());
            this.userProviderService.editXhPersonal(editUserParam);
            return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            this.logger.error("DuplicateKeyException:", (Throwable)e);
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"forbiddenSelf"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenParam param) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(ShiroUtil.getLoginUserId());
        param.setIdList(null);
        param.setIdList(ids);
        param.setIsForbidden(Integer.valueOf(1));
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/modifyPasswordByOldPwd"})
    @ApiEncrypt(request=true)
    public ResponseData<String> modifyPasswordByOldPwd(@RequestBody MdOldPsdParam param) {
        return ResponseData.fail();
    }

    @RequestLimit(maxCount=1000, second=43200)
    @RequestMapping(value={"faceAuth"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<Boolean> faceAuth(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) {
        return ResponseData.success((String)"\u8ba4\u8bc1\u901a\u8fc7\uff01", (Object)true);
    }

    @Generated
    public PersonalCenterController(OssClientBean ossClientBean, BaiduApiService baiduApiService, H5Converter converter) {
        this.ossClientBean = ossClientBean;
        this.baiduApiService = baiduApiService;
        this.converter = converter;
    }
}

