/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.pay;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.AlipayProperties;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.provider.order.ISysOrderProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import jakarta.validation.constraints.NotEmpty;
import java.util.HashMap;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alipay"})
@Validated
public class AlipayController
extends ControllerSupport {
    private static final String info_prefix = "[\u652f\u4ed8\u5b9d\u652f\u4ed8]";
    private final AlipayProperties options;
    @DubboReference
    private ISysOrderProviderService sysOrderService;

    @Log(title="\u521b\u5efa\u624b\u673a\u7f51\u9875\u652f\u4ed8\u8ba2\u5355", logModule=LogModuleTypeEnum.order, type=LogTypeEnum.type_opt_add)
    @RequestLimit(maxCount=5, second=60)
    @PostMapping(value={"/addWapPayOrder"})
    public ResponseData<Object> addWapPayOrder(@RequestBody IdParam param) {
        this.logger.info("{}-\u521b\u5efa\u624b\u673a\u7f51\u9875\u652f\u4ed8\u8ba2\u5355-UserId:{}-\u8ba2\u5355id\uff1a{}", new Object[]{info_prefix, ShiroUtil.getLoginUserId(), param.getId()});
        SysOrder sysOrder = this.sysOrderService.getById(param.getId());
        if (sysOrder == null) {
            return ResponseData.fail((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u8ba2\u5355");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.options.gatewayHost, this.options.appId, this.options.merchantPrivateKey, "json", "UTF-8", this.options.alipayPublicKey, this.options.signType);
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(sysOrder.getId().toString());
        model.setTotalAmount(sysOrder.getGoodsPrice().toString());
        model.setSubject(sysOrder.getSubject());
        model.setProductCode("QUICK_WAP_WAY");
        model.setTimeoutExpress("30m");
        model.setQuitUrl(this.options.quitUrl.concat(param.getId().toString()));
        request.setNotifyUrl(this.options.notifyUrl);
        request.setReturnUrl(this.options.returnUrl);
        request.setBizModel((AlipayObject)model);
        String pageRedirectionData = null;
        try {
            AlipayTradeWapPayResponse response = (AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)request, "POST");
            if (!response.isSuccess()) {
                this.logger.debug("\u8c03\u7528\u5931\u8d25-subMsg:{}", (Object)response.getSubMsg());
                return ResponseData.success((String)response.getSubMsg());
            }
            pageRedirectionData = response.getBody();
            this.logger.debug("\u8c03\u7528\u6210\u529f-pageRedirectionData:{}", (Object)pageRedirectionData);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("pageRedirectionData", pageRedirectionData);
        result.put("outTradeNo", sysOrder.getId().toString());
        return new ResponseData(result);
    }

    @GetMapping(value={"/trade_query"})
    public ResponseData<String> trade_check(@NotEmpty String tradeNo) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.options.gatewayHost, this.options.appId, this.options.merchantPrivateKey, "json", "UTF-8", this.options.alipayPublicKey, this.options.signType);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(tradeNo);
        request.setBizModel((AlipayObject)model);
        AlipayTradeQueryResponse response = null;
        try {
            response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (AlipayApiException e) {
            this.logger.error("\u652f\u4ed8\u5b9d\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 tradeNo: {}, error: {}", new Object[]{tradeNo, e.getErrMsg(), e});
            return ResponseData.fail((String)"ALIPAY_SERVICE_ERROR");
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38 tradeNo: {}", (Object)tradeNo, (Object)e);
            return ResponseData.fail((String)"SYSTEM_ERROR");
        }
        if (response != null && response.isSuccess()) {
            return ResponseData.success((String)response.getTradeStatus());
        }
        return ResponseData.success((String)"WAIT_BUYER_PAY");
    }

    @Generated
    public AlipayController(AlipayProperties options) {
        this.options = options;
    }
}

