/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.order;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderLog;
import cn.smarthse.radiationTraining.modules.sys.param.order.UserQueryOrderParam;
import cn.smarthse.radiationTraining.modules.sys.provider.order.ISysOrderLogProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.order.ISysOrderProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderDetailModel;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
public class OrderController
extends ControllerSupport {
    private final String info_prefix = "[\u8ba2\u5355\u7ba1\u7406-\u7528\u6237\u7aef]";
    @DubboReference
    private ISysOrderProviderService sysOrderService;
    @DubboReference
    private ISysOrderLogProviderService sysOrderLogService;

    @GetMapping(value={"/getOrderListDataByUser"})
    public ResponseData<LayuiGridData<SysOrderDetailModel>> getOrderListDataByUser(UserQueryOrderParam param) {
        this.logger.debug("{}-\u67e5\u8be2\u8ba2\u5355\u5217\u8868-param\uff1a{}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u7528\u6237\u7aef]", (Object)param);
        param.setUserId(ShiroUtil.getLoginUserId());
        return ResponseData.success((Object)this.sysOrderService.getUserOrderListData(param));
    }

    @GetMapping(value={"/getOrderDetails"})
    public ResponseData<SysOrderDetailModel> getOrderDetails(IdParam param) {
        this.logger.info("{}-\u8ba2\u5355\u8be6\u60c5-param={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u7528\u6237\u7aef]", (Object)param);
        SysOrderDetailModel orderModel = this.sysOrderService.getOrderDetails(param.getId());
        if (orderModel != null && !Objects.equals(orderModel.getUserId(), ShiroUtil.getLoginUserId())) {
            return ResponseData.fail((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        return ResponseData.success((Object)orderModel);
    }

    @PostMapping(value={"/refundApply"})
    public ResponseData<String> refundApply(@RequestBody IdParam param) {
        this.logger.info("{}-\u8ba2\u5355\u9000\u6b3e-\u9000\u6b3e\u7533\u8bf7orderId={}", (Object)"[\u8ba2\u5355\u7ba1\u7406-\u7528\u6237\u7aef]", (Object)param.getId());
        this.sysOrderService.applyRefund(param.getId(), ShiroUtil.getLoginUserId(), ShiroUtil.getLoginUsername());
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getOrderLogList"})
    public ResponseData<List<SysOrderLog>> getOrderLogList(IdParam orderId) {
        this.logger.debug("{}-\u8ba2\u5355\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2-userId={}\uff0corderId={}", new Object[]{"[\u8ba2\u5355\u7ba1\u7406-\u7528\u6237\u7aef]", ShiroUtil.getLoginUserId(), orderId.getId()});
        return ResponseData.success((Object)this.sysOrderLogService.getOrderLogList(orderId.getId(), ShiroUtil.getLoginUserId()));
    }

    @Generated
    public OrderController() {
    }
}

