/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.examCenter;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.question.entity.PaperInstructions;
import cn.smarthse.radiationTraining.modules.question.param.ExamRecordsSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.SubmitExamParam;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperInstructionsProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperResultVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamRecordVo;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.param.course.TuCoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.service.ExamService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/examCenter"})
public class ExamCenterController
extends ControllerSupport {
    private final String info_prefix = "[\u8003\u8bd5\u4e2d\u5fc3]";
    @DubboReference
    private ITuCourseProviderService tuCourseProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser trainingProviderService;
    @DubboReference
    private IPaperInstructionsProviderService paperInstructionsProviderService;
    @Autowired
    private ExamService examService;

    @GetMapping(value={"getTrainingExamList"})
    public ResponseData<LayuiGridData<UserMyTrainListVo>> getTrainingExamList(UserMyTrainSearchParam param) {
        this.logger.debug("{}-\u67e5\u8be2\u57f9\u8bad\u8003\u8bd5\u5217\u8868...", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]");
        param.setUid(ShiroUtil.getLoginUserId());
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        return new ResponseData((Object)this.trainingProviderService.getMyTrainingExamPageList(param));
    }

    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<UserMyTrainListVo> getMyTrainingBaseInfo(Long id) {
        this.logger.debug("{}-\u67e5\u770b\u57f9\u8bad\u57fa\u672c\u4fe1\u606f\uff1aid-{}", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]", (Object)id);
        return new ResponseData((Object)this.trainingProviderService.getTrainingBaseInfo(id));
    }

    @GetMapping(value={"getTuCourseExamPageList"})
    public ResponseData<LayuiGridData<TuCourseVo>> getTuCourseExamPageList(TuCoursePageParam pageParam) {
        this.logger.debug("{}-\u67e5\u8be2\u8bfe\u7a0b\u8003\u8bd5\u5217\u8868\uff1atid-{}", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]", (Object)pageParam.getTid());
        pageParam.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getTuCourseExamPageList(pageParam));
    }

    @GetMapping(value={"getCourseExamList"})
    public ResponseData<LayuiGridData<ExamRecordVo>> getCourseExamList(ExamRecordsSearchParam param) {
        this.logger.debug("{}-\u67e5\u770b\u8bfe\u7a0b\u8003\u8bd5\u8bb0\u5f55\uff1atuCourseId-{}", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]", (Object)param.getTuCourseId());
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData(this.examService.getExamRecords(param));
    }

    @GetMapping(value={"getCourseExamDetail"})
    public ResponseData<ExamPaperResultVo> getCourseExamDetail(Long id) {
        this.logger.debug("{}-\u67e5\u770b\u8bfe\u7a0b\u8003\u8bd5\u8bb0\u5f55\u8be6\u60c5\uff1atuPaperId-{}", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]", (Object)id);
        return new ResponseData((Object)this.examService.getCourseExamDetail(id));
    }

    @RequestLimit(second=10, maxCount=1, msg="\u60a8\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01")
    @PostMapping(value={"/getExamQuestios"})
    @ResponseBody
    public ResponseData<ExamPaperDataVo> getExamQuestions(@RequestBody StartExamParam param) {
        this.logger.debug("{}-\u83b7\u53d6\u8bd5\u9898", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]");
        param.setUserId(ShiroUtil.getLoginUserId());
        if (param.getTestMode() == 0) {
            return ResponseData.success((Object)this.examService.getExamQuestions(param));
        }
        if (param.getTestMode() == 1) {
            param.setTuCourseId(null);
            return ResponseData.success((Object)this.examService.getCentralizedExamQuestions(param));
        }
        return ResponseData.fail((String)"\u751f\u6210\u8bd5\u9898\u5f02\u5e38\uff01");
    }

    @RequestLimit(second=20, maxCount=1)
    @PostMapping(value={"/submitExam"})
    @ResponseBody
    public ResponseData<ExamPaperResultVo> SubmitExam(@RequestBody SubmitExamParam param) {
        this.logger.debug("{}-\u8003\u8bd5\u7ed3\u7b97\uff1a\u7b54\u6848\u63d0\u4ea4", (Object)"[\u8003\u8bd5\u4e2d\u5fc3]");
        return ResponseData.success((Object)this.examService.submitExam(param));
    }

    @GetMapping(value={"getInstruction"})
    public ResponseData<PaperInstructions> getAbout(Integer trainTarget) {
        if (trainTarget == null) {
            trainTarget = 0;
        }
        return new ResponseData((Object)this.paperInstructionsProviderService.getPaperInstructions(trainTarget, ShiroUtil.getLoginUserId()));
    }
}

