/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.extra.pinyin.PinyinUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.model.zlb.PersonInfo;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.modules.datacentre.provider.zlb.IZlbUserInfoProviderService;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.enums.SexEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.wx.service.zlb.IZlbClientServiceService;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.validation.constraints.NotBlank;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
@Validated
public class ZlbLoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final IZlbClientServiceService zlbClientService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private IZlbUserInfoProviderService zlbUserInfoProviderService;

    @BigLog(userRole=UserRoleEnum.MASSES_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module13)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55")
    @PostMapping(value={"/zlb/v2"})
    public ResponseData<LoginData> loginByZlbV2(@NotBlank(message="zlbUserId\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="zlbUserId\u4e0d\u80fd\u4e3a\u7a7a") String zlbUserId, @NotBlank(message="userType\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="userType\u4e0d\u80fd\u4e3a\u7a7a") String userType, String areaIdStr) {
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55: zlbUserId\uff1a{}\uff0cuserType: {}\uff0careaIdStr: {}", new Object[]{zlbUserId, userType, areaIdStr});
        return this.login(this.zlbUserInfoProviderService.getUserInfo(zlbUserId, userType), areaIdStr);
    }

    @PostMapping(value={"/getZlbUserInfo"})
    public ResponseData<Map<String, String>> getZlbUserInfo(@NotBlank(message="ticket\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="ticket\u4e0d\u80fd\u4e3a\u7a7a") String ticket, @NotBlank(message="appId\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="appId\u4e0d\u80fd\u4e3a\u7a7a") String appId) {
        ZlbUserInfo zlbUserInfo = this.zlbClientService.getZlbUserInfo(ticket, appId);
        if (Objects.isNull(zlbUserInfo)) {
            return ResponseData.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        this.zlbUserInfoProviderService.saveZlbUserInfo(zlbUserInfo);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userType", zlbUserInfo.getUserType());
        if ("PERSON".equalsIgnoreCase(zlbUserInfo.getUserType())) {
            result.put("nickName", DesensitizationUtils.desensitized((CharSequence)zlbUserInfo.getPersonInfo().getUserName(), (DesensitizationType)DesensitizationType.NAME));
            result.put("zlbUserId", zlbUserInfo.getPersonInfo().getUserId());
        } else {
            result.put("nickName", zlbUserInfo.getLegalPersonInfo().getName());
            result.put("zlbUserId", zlbUserInfo.getLegalPersonInfo().getCorpId());
        }
        return ResponseData.success(result);
    }

    private ResponseData<LoginData> login(ZlbUserInfo zlbUserInfo, String areaIdStr) {
        if (Objects.isNull(zlbUserInfo)) {
            return ResponseData.fail((String)"\u767b\u5165\u5931\u8d25\uff01");
        }
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55 \u767b\u5f55\u8fc7\u7a0b: start {}", (Object)zlbUserInfo.getUserId());
        if (!"PERSON".equalsIgnoreCase(zlbUserInfo.getUserType())) {
            return ResponseData.fail((String)"\u6cd5\u4eba\u7528\u6237\u65e0\u6743\u9650\uff01");
        }
        PersonInfo personInfo = zlbUserInfo.getPersonInfo();
        SysUser exists = this.userProviderService.getUserByZlbUserId(zlbUserInfo.getUserId());
        if (exists == null && (exists = this.userProviderService.getOneByIdCard(personInfo.getIdNo())) == null && (exists = this.userProviderService.getUserByUsername(personInfo.getPhone(), SysUserTypeEnum.USER.getValue())) == null) {
            exists = this.userProviderService.getUserByPhone(personInfo.getPhone());
        }
        Long areaId = null;
        if (StringUtils.isNotBlank((CharSequence)areaIdStr)) {
            try {
                Long.parseLong(areaIdStr);
                String paddedAreaIdStr = String.format("%-12d", Long.parseLong(areaIdStr)).replace(' ', '0');
                areaId = Long.parseLong(paddedAreaIdStr);
            }
            catch (Exception paddedAreaIdStr) {
                // empty catch block
            }
        }
        if (exists == null) {
            RegisterUserParam userParam = new RegisterUserParam();
            if (StringUtils.isBlank((CharSequence)personInfo.getPhone())) {
                String idNo_suffix;
                String username_prefix = PinyinUtil.getFirstLetter((String)personInfo.getUserName(), (String)"");
                String string = idNo_suffix = personInfo.getIdNo() != null && personInfo.getIdNo().length() >= 6 ? personInfo.getIdNo().substring(personInfo.getIdNo().length() - 6) : "";
                if (StringUtils.isBlank((CharSequence)(username_prefix + idNo_suffix))) {
                    userParam.setUsername("zlb" + System.currentTimeMillis());
                } else {
                    long count = this.userProviderService.getSameUsernameCount(username_prefix + idNo_suffix);
                    userParam.setUsername(username_prefix + idNo_suffix + String.valueOf(++count >= 10L ? Long.valueOf(count) : "0" + count));
                }
            } else {
                userParam.setUsername(personInfo.getPhone());
            }
            userParam.setName(personInfo.getUserName());
            userParam.setPassword("Zyj@2022");
            userParam.setIdcard(personInfo.getIdNo());
            userParam.setIdcardType(IdcardTypeEnum.getValueByCode((String)personInfo.getIdType()));
            userParam.setSex(SexEnum.getValueByCode((String)personInfo.getGender()));
            userParam.setPhone(personInfo.getPhone());
            userParam.setZlbUserId(personInfo.getUserId());
            userParam.setAreaId(areaId);
            exists = this.userProviderService.personalUserRegister(userParam);
        } else {
            this.userProviderService.updateIdcard(exists.getId(), personInfo.getUserName(), personInfo.getIdNo(), IdcardTypeEnum.getValueByCode((String)personInfo.getIdType()), areaId);
            try {
                this.userProviderService.updatePhoneForZlb(exists.getId(), personInfo.getPhone());
            }
            catch (Exception e) {
                this.logger.error("\u6d59\u91cc\u529e\u767b\u5f55 \u767b\u5f55\u8fc7\u7a0b \u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff08\u4e0d\u5f71\u54cd\u767b\u5f55\uff09: end {}", (Object)zlbUserInfo.getUserId(), (Object)e);
            }
        }
        LoginData result = this.loginService.loginByUsername(exists.getUsername(), zlbUserInfo.getUserId());
        result.setNickName(DesensitizationUtils.desensitized((CharSequence)personInfo.getUserName(), (DesensitizationType)DesensitizationType.NAME));
        result.setZlbUserId(personInfo.getUserId());
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55 \u767b\u5f55\u8fc7\u7a0b: end {}", (Object)zlbUserInfo.getUserId());
        result.getUser().getUser().setName(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUser().getName(), (DesensitizationType)DesensitizationType.NAME));
        result.getUser().getUser().setUsername(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUser().getUsername(), (DesensitizationType)DesensitizationType.NAME));
        result.getUser().getUser().setPhone(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUser().getPhone(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        result.getUser().getUser().setEmail(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUser().getEmail(), (DesensitizationType)DesensitizationType.EMAIL));
        result.getUser().getUser().setPassword(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUser().getPassword(), (DesensitizationType)DesensitizationType.PASSWORD));
        result.getUser().getUserInfo().setName(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUserInfo().getName(), (DesensitizationType)DesensitizationType.NAME));
        result.getUser().getUserInfo().setIdcard(DesensitizationUtils.desensitized((CharSequence)result.getUser().getUserInfo().getIdcard(), (DesensitizationType)DesensitizationType.ID_CARD));
        return ResponseData.success((Object)result);
    }

    @Generated
    public ZlbLoginController(LoginService loginService, IZlbClientServiceService zlbClientService) {
        this.loginService = loginService;
        this.zlbClientService = zlbClientService;
    }
}

