/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.user.CheckPhoneParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.CheckUsernameParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterXhUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PhoneParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/register"})
@Validated
public class UserRegisterController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference(registry={"local_nacos"})
    private IUserProviderService userProviderService;

    @PostMapping(value={"/user/p"})
    @Log(title="\u4e2a\u4eba\u7528\u6237\u6ce8\u518c(\u624b\u673a\u53f7)", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt_edit)
    @RequestLimit(second=60, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c\uff01")
    public ResponseData<LoginData> personalUserRegister3(@RequestBody RegisterXhUserParam userParam) {
        FieldCheckUtils.checkEmptyFields((Object)userParam, (String[])new String[]{"password", "phone", "vcode", "uuid"});
        this.logger.info("\u534f\u4f1a\u4e2a\u4eba\u7528\u6237\u6ce8\u518c: {}", (Object)DesensitizationUtils.desensitized((CharSequence)userParam.getPhone(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        userParam.setPhone(StringUtils.trim((String)userParam.getPhone()));
        userParam.setUsername(StringUtils.trim((String)userParam.getPhone()));
        userParam.setVcode(userParam.getVcode().toUpperCase());
        if (!this.loginService.checkPhoneRegisterCode(userParam.getPhone(), userParam.getVcode())) {
            return ResponseData.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        try {
            userParam.setUsername("xh" + System.currentTimeMillis());
            String privateKey = (String)RedisUtils.getCacheObject((String)userParam.getUuid());
            RedisUtils.deleteObject((String)userParam.getUuid());
            String password = RsaUtil.decrypt((String)userParam.getPassword(), (String)privateKey);
            userParam.setPassword(password);
            this.userProviderService.personalUserRegisterForXh(userParam);
            this.loginService.cleanCache(RedisKey.getPhoneRegisterCodeKey((String)userParam.getPhone()));
            return ResponseData.success((String)"\u6ce8\u518c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("DuplicateKeyException\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u6ce8\u518c\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"/checkUsername"})
    public ResponseData<Boolean> checkPhone(@RequestBody CheckUsernameParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"phone"});
        SysUser user = this.userProviderService.getUserByPhone(param.getPhone());
        if (user == null) {
            return ResponseData.success((String)"\u8d26\u53f7\u53ef\u7528", (Object)true);
        }
        if (user.getHasRegisteredXh() == 0) {
            return ResponseData.success((String)"\u8d26\u53f7\u53ef\u7528", (Object)true);
        }
        return ResponseData.success((String)"\u8d26\u53f7\u4e0d\u53ef\u7528", (Object)false);
    }

    @PostMapping(value={"/checkPhoneCode"})
    @RequestLimit(maxCount=2, second=60)
    public ResponseData<Boolean> checkPhoneCode(@RequestBody CheckPhoneParam param) {
        if (StrUtil.isBlank((CharSequence)param.getPhone()) || StrUtil.isBlank((CharSequence)param.getCode()) || param.getType() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        param.setCode(param.getCode().toUpperCase());
        boolean flag = false;
        if (param.getType() == 1) {
            flag = this.loginService.checkPhoneRegisterCode(param.getPhone(), param.getCode());
        }
        return ResponseData.success((String)(flag ? "\u6821\u9a8c\u6210\u529f" : "\u6821\u9a8c\u5931\u8d25"), (Object)flag);
    }

    @Log(title="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801(\u6ce8\u518c)", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt)
    @RequestLimit(maxCount=1, second=60)
    @PostMapping(value={"/sendMobileCode/Register"})
    @ApiEncrypt(request=true, response=false)
    public ResponseData<Boolean> sendMobileRegisterCode(@RequestBody PhoneParam mobile) {
        return ResponseData.success((Object)this.loginService.sendPhoneCodeForRegister(mobile.getPhone()));
    }

    @Generated
    public UserRegisterController(LoginService loginService) {
        this.loginService = loginService;
    }
}

