/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.ModifyPasswordParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PhoneParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uno/pw/un"})
@Validated
public class PasswordUnOnlineController
extends ControllerSupport {
    private final LoginService loginService;
    private final StringRedisTemplate stringRedisTemplate;
    @DubboReference
    private IUserProviderService userProviderService;

    @Log(title="\u53d1\u9001\u624b\u673a\u5fd8\u8bb0\u5bc6\u7801\u9a8c\u8bc1\u7801-\u672a\u767b\u5f55", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt)
    @RequestLimit(maxCount=1, second=60)
    @ApiEncrypt(request=true, response=false)
    @PostMapping(value={"/sendMobileCode/md"})
    public ResponseData<Boolean> sendMobileMdCode(@RequestBody PhoneParam mobile) {
        return ResponseData.success((Object)this.loginService.sendPhoneCodeForMD(mobile.getPhone()));
    }

    @Log(title="\u4fee\u6539\u5bc6\u7801-\u672a\u767b\u5f55", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/modifyPassword"})
    @ApiEncrypt(request=true, response=false)
    public ResponseData<String> modifyPasswordInOnline(@RequestBody ModifyPasswordParam param) {
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{param.getUuid(), param.getNewPassword(), param.getPhone()})) {
            throw new ServiceException("\u4fe1\u606f\u9519\u8bef\uff01");
        }
        try {
            String privateKey = (String)this.stringRedisTemplate.opsForValue().get((Object)param.getUuid());
            this.stringRedisTemplate.delete((Object)param.getUuid());
            String newPassword = RsaUtil.decrypt((String)param.getNewPassword(), (String)privateKey);
            String phoneCode = RsaUtil.decrypt((String)param.getCode(), (String)privateKey);
            param.setCode(phoneCode);
            param.setMwNewPassword(newPassword);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25");
        }
        this.loginService.modifyPasswordUnOnline(param);
        return ResponseData.success();
    }

    @Generated
    public PasswordUnOnlineController(LoginService loginService, StringRedisTemplate stringRedisTemplate) {
        this.loginService = loginService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

