/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PasswordLoginParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PublicKeyParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import jakarta.validation.constraints.NotBlank;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final StringRedisTemplate stringRedisTemplate;
    @DubboReference
    private IUserProviderService userProviderService;
    private static final int md5PasswordLength = 33;

    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @RequestLimit(second=60, maxCount=1, msg="\u8bf71\u5206\u949f\u540e\u91cd\u8bd5")
    @PostMapping(value={"/sendEmailCode"})
    public ResponseData<Boolean> sendEmailCode(String email) {
        SysUser exists = this.userProviderService.getOneByEmail(email);
        if (exists == null) {
            return ResponseData.fail((String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\uff01");
        }
        return ResponseData.success((Object)this.loginService.sendEmailCodeForResetPwd(email, exists.getUsername()));
    }

    @PostMapping(value={"/sendVcode"})
    public ResponseData<String> sendVcode(@NotBlank(message="key\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="key\u4e0d\u80fd\u4e3a\u7a7a") String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVcode(key));
    }

    @PostMapping(value={"/checkEmailCode"})
    public ResponseData<Boolean> checkEmailCode(String email, @NotBlank(message="\u9a8c\u8bc1\u7801") @NotBlank(message="\u9a8c\u8bc1\u7801") String code) {
        return ResponseData.success((Object)this.loginService.checkEmailCode(email, code));
    }

    @PostMapping(value={"/getPublicKey"})
    @ApiEncrypt(request=false, response=true)
    public ResponseData<String> getPublicKey(@RequestBody PublicKeyParam param) {
        if (param.getUuid() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringStringMap = RsaUtil.genKeyPair();
        this.logger.debug("publicKeyMap: {}", (Object)stringStringMap);
        String privateKey = (String)stringStringMap.get("privateKey");
        this.stringRedisTemplate.opsForValue().set((Object)param.getUuid(), (Object)privateKey, 30L, TimeUnit.MINUTES);
        return ResponseData.success((String)"\u6210\u529f", (Object)((String)stringStringMap.get("publicKey")));
    }

    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u5728\u7ebf\u57f9\u8badweb\u767b\u5165")
    @RequestLimit(maxCount=2, second=60)
    @PostMapping(value={"/web/password"})
    @ApiEncrypt(request=true, response=true)
    public ResponseData<LoginData> loginByPasswordForWeb(@RequestBody PasswordLoginParam param) {
        String username = param.getUsername();
        String password = param.getPassword();
        String key = param.getKey();
        String code = param.getCode();
        String uuid = param.getUuid();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{username, password, uuid, key, code})) {
            throw new ServiceException("\u767b\u5f55\u5931\u8d25\uff01");
        }
        this.logger.info("\u5bc6\u7801\u767b\u5f55: {}", (Object)username);
        if (!this.loginService.checkVcode(key, code, true)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        String privateKey = (String)this.stringRedisTemplate.opsForValue().get((Object)uuid);
        this.stringRedisTemplate.delete((Object)uuid);
        if (privateKey == null) {
            ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff01");
        }
        password = RsaUtil.decrypt((String)password, (String)privateKey);
        return ResponseData.success((Object)this.loginService.loginByPassword(username, password));
    }

    @Generated
    public LoginController(LoginService loginService, StringRedisTemplate stringRedisTemplate) {
        this.loginService = loginService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

