/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserInfoProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.PermissionsService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.User;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TokenService {
    @DubboReference
    private IUserProviderService userService;
    @DubboReference
    private IUserInfoProviderService userInfoProviderService;
    private final PermissionsService permissionsService;
    @Resource
    private RedisTemplate<String, ShiroPrincipal> redisTemplate;
    @DubboReference
    private ISysCompanyStaffProviderService companyStaffProviderService;

    public void doGetAuthorizationInfo(ShiroPrincipal principal) {
        this.permissionsService.addRoleAndPerms(principal);
    }

    public ShiroPrincipal getLoginUser(Long userId) {
        if (userId == null) {
            return null;
        }
        String loginUserKey = RedisKey.getWXLoginUserKey((Long)userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            SysUser user = this.userService.selectUserById(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6388\u6743\u5931\u8d25\uff01");
            }
            principal.setUser(new User(user));
            principal.setUserInfo(this.userInfoProviderService.getUserInfo(principal.getUserId()));
            this.permissionsService.addRoleAndPerms(principal);
            this.initCompanyInfo(principal);
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public SysUser selectUserByPhone(String phone) {
        return this.userService.selectUserByPhone(phone);
    }

    public void register(String phone) {
        this.userService.register(phone, new String[0]);
    }

    public SysUser getUserByUsername(String username, Integer userType) {
        return this.userService.getUserByUsername(username, userType);
    }

    public SysUser getUserByToken(String username, Integer userType) {
        return this.userService.getUserByToken(username, userType);
    }

    private void initCompanyInfo(ShiroPrincipal principal) {
        List companyList = this.companyStaffProviderService.getByUidAndSource(principal.getUserId(), null);
        if (CollectionUtils.isEmpty((Collection)companyList) || companyList.get(0) == null) {
            return;
        }
        principal.setCid(((CompanyListVo)companyList.get(0)).getId());
        principal.setCompanyName(((CompanyListVo)companyList.get(0)).getName());
    }

    public void bindZlbUserId(Long gjUserId, String zlbUserId) {
        this.userService.bindZlbUserId(gjUserId, zlbUserId);
    }

    @Generated
    public TokenService(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }
}

