/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.utils.CommonsUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.ModifyPasswordOnlineParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.ModifyPasswordParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IEmailProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISmsProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserInfoProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.PhoneCodeToken;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.RegisterToken;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import com.wf.captcha.SpecCaptcha;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISmsProviderService smsProviderService;
    @DubboReference
    private IUserInfoProviderService userInfoProviderService;
    @DubboReference
    private IEmailProviderService emailProviderService;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final TokenService tokenService;
    @DubboReference
    private ISysCompanyStaffProviderService companyStaffProviderService;

    public boolean sendLoginCode(String phone) {
        return true;
    }

    public boolean sendEmailCodeForRegister(String email) {
        String code = RandomUtil.randomStringUpper((int)6);
        log.debug("\u90ae\u7bb1\u9a8c\u8bc1\u7801-\u6ce8\u518c\uff1a{} \uff1a {}", (Object)email, (Object)code);
        String text = String.format("\u3010\u6d59\u6c5f\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u7cfb\u7edf\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u662f\uff1a%s\uff0c\u7528\u4e8e\u8d26\u53f7\u6ce8\u518c\uff0c5\u5206\u949f\u5185\u6709\u6548\uff01\u4e3a\u4e86\u60a8\u7684\u4fe1\u606f\u5b89\u5168\uff0c\u8bf7\u52ff\u5c06\u9a8c\u8bc1\u7801\u6cc4\u9732\u7ed9\u4ed6\u4eba\u3002\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u6211\u4eec\uff1a0571-89978771\u3002", code);
        this.emailProviderService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword((String)code, (String)email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey((String)email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME_2.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public boolean sendPhoneCodeForRegister(String phone) {
        SysUser user = this.userProviderService.getUserByPhone(phone);
        if (user != null && user.getHasRegisteredXh() != 0) {
            throw new ServiceException("\u65e0\u6cd5\u53d1\u9001\u6ce8\u518c\u9a8c\u8bc1\u7801");
        }
        String code = RandomUtil.randomString((int)3);
        String code2 = RandomUtil.randomNumbers((int)3);
        String result = (code + code2).toUpperCase();
        log.debug("\u624b\u673a\u9a8c\u8bc1\u7801-\u6ce8\u518c\uff1a{} \uff1a {}", (Object)DesensitizationUtils.desensitized((CharSequence)phone, (DesensitizationType)DesensitizationType.MOBILE_PHONE), (Object)result);
        this.smsProviderService.sendVCodeSmsForXH(result, phone);
        String encryptCode = CommonsUtils.encryptPassword((String)result, (String)phone);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getPhoneRegisterCodeKey((String)phone), (Object)encryptCode, (long)Constant.PHONE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public boolean sendPhoneCodeForMD(String phone) {
        SysUser user = this.userProviderService.getUserByPhone(phone);
        if (user == null || user.getHasRegisteredXh() == 0) {
            throw new ServiceException("\u65e0\u6cd5\u53d1\u9001\u6ce8\u518c\u9a8c\u8bc1\u7801");
        }
        String code = RandomUtil.randomString((int)3);
        String code2 = RandomUtil.randomNumbers((int)3);
        String result = (code + code2).toUpperCase();
        log.debug("\u624b\u673a\u9a8c\u8bc1\u7801-\u5fd8\u8bb0\u5bc6\u7801\uff1a{} \uff1a {}", (Object)DesensitizationUtils.desensitized((CharSequence)phone, (DesensitizationType)DesensitizationType.MOBILE_PHONE), (Object)result);
        this.smsProviderService.sendVCodeSmsForXH(result, phone);
        String encryptCode = CommonsUtils.encryptPassword((String)result, (String)user.getSalt());
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getPhoneMdCodeKey((String)phone), (Object)encryptCode, (long)Constant.PHONE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public boolean sendEmailCodeForResetPwd(String email, String username) {
        if (!Validator.isEmail((CharSequence)email)) {
            log.error("\u53d1\u9001\u90ae\u4ef6-\u90ae\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a{}", (Object)email);
            return false;
        }
        String code = RandomUtil.randomStringUpper((int)6);
        log.debug("\u90ae\u7bb1\u9a8c\u8bc1\u7801-\u91cd\u7f6e\u5bc6\u7801\uff1a{} \uff1a {}", (Object)email, (Object)code);
        if (StringUtils.checkMobile((String)username)) {
            username = DesensitizationUtils.desensitized((CharSequence)username, (DesensitizationType)DesensitizationType.MOBILE_PHONE);
        }
        String text = String.format("\u3010\u6d59\u6c5f\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u7cfb\u7edf\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u662f\uff1a%s\uff0c\u7528\u4e8e\u8d26\u53f7\u201c%s\u201d\u91cd\u7f6e\u5bc6\u7801\uff0c5\u5206\u949f\u5185\u6709\u6548\uff01\u4e3a\u4e86\u60a8\u7684\u4fe1\u606f\u5b89\u5168\uff0c\u8bf7\u52ff\u5c06\u9a8c\u8bc1\u7801\u6cc4\u9732\u7ed9\u4ed6\u4eba\u3002\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u6211\u4eec\uff1a0571-89978771\u3002", code, username);
        this.emailProviderService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword((String)code, (String)email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey((String)email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public String sendVcode(String key) {
        SpecCaptcha specCaptcha = new SpecCaptcha(130, 48, 4);
        String code = specCaptcha.text().toLowerCase();
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getVCodeKey((String)key), (Object)code, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return specCaptcha.toBase64();
    }

    public LoginData loginByPassword(String phone, String password) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(phone, password);
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        catch (HealthException | ServiceException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u624b\u673a\u53f7\u5bc6\u7801\u767b\u9646\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginData loginByCode(String phone, String code) {
        Subject subject = SecurityUtils.getSubject();
        PhoneCodeToken token = new PhoneCodeToken(phone, code);
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            return this.returnLoginInitParam(principal);
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        catch (HealthException | ServiceException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u624b\u673a\u53f7or\u90ae\u7bb1\u9a8c\u8bc1\u7801\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginData loginByUsername(String username, String zlbUserId) {
        Subject subject = SecurityUtils.getSubject();
        RegisterToken token = new RegisterToken(username, zlbUserId);
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            principal.setLoginFrom(2);
            return this.returnLoginInitParam(principal);
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        catch (HealthException | ServiceException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u6ce8\u518c\u540e\u6839\u636eusername\u81ea\u52a8\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public void modifyPasswordByEmail(String email, String code, String password) {
        Object emailCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey((String)email));
        if (Objects.isNull(emailCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)email);
        if (!Objects.equals(emailCode, encryptCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        this.stringRedisTemplate.delete((Object)RedisKey.getEmailCodeKey((String)email));
        this.userProviderService.modifyPasswordByEmail(email, password);
    }

    public void modifyPasswordByPhone(String phone, String code, String password) {
        Object phoneCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getPhoneCodeKey((String)phone));
        if (Objects.isNull(phoneCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)phone);
        if (!Objects.equals(phoneCode, encryptCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        this.stringRedisTemplate.delete((Object)RedisKey.getPhoneCodeKey((String)phone));
        this.userProviderService.modifyPasswordByPhone(phone, password);
    }

    public void modifyPasswordOnline(ModifyPasswordOnlineParam param) {
        String newPassword = param.getMwNewPassword();
        String oldPassword = param.getMwOldPassword();
        String passwordDB = null;
        SysUser userDB = this.userProviderService.getFullUserInfoById(param.getUserId());
        SysUserInfo userInfoDB = null;
        if (userDB != null) {
            userInfoDB = userDB.getSysUserInfo();
        }
        passwordDB = userDB.getPassword();
        if (userDB == null || userInfoDB == null) {
            throw new ServiceException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        if ("Zyj@2022".equals(newPassword)) {
            throw new ServiceException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        String encryptPassword = CommonsUtils.encryptPassword((String)oldPassword, (String)userDB.getSalt());
        if (!passwordDB.equals(encryptPassword)) {
            throw new ServiceException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        if (passwordDB.equals(CommonsUtils.encryptPassword((String)newPassword, (String)userDB.getSalt()))) {
            throw new ServiceException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        this.userProviderService.modifyPassword(param.getUserId(), param.getMwNewPassword());
    }

    public void modifyPasswordUnOnline(ModifyPasswordParam param) {
        String newPassword = param.getMwNewPassword();
        String passwordDB = null;
        SysUser userDB = this.userProviderService.getUserByPhone(param.getPhone());
        UserInfo userInfoDB = null;
        if (userDB != null) {
            userInfoDB = this.userInfoProviderService.getUserInfo(userDB.getId());
        }
        passwordDB = userDB.getPassword();
        if (userDB == null || userInfoDB == null) {
            throw new ServiceException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        String phoneCodeRed = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getPhoneMdCodeKey((String)param.getPhone()));
        String phoneCodeUser = CommonsUtils.encryptPassword((String)param.getCode(), (String)userDB.getSalt());
        if (StrUtil.isBlank((CharSequence)phoneCodeRed)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        if (!StrUtil.equals((CharSequence)phoneCodeRed, (CharSequence)phoneCodeUser)) {
            throw new ServiceException("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        if ("Zyj@2022".equals(newPassword)) {
            throw new ServiceException("\u4e0d\u80fd\u4e0e\u9ed8\u8ba4\u5bc6\u7801\u76f8\u540c\uff01");
        }
        this.userProviderService.modifyPassword(userDB.getId(), param.getMwNewPassword());
        this.stringRedisTemplate.delete((Object)RedisKey.getPhoneMdCodeKey((String)param.getPhone()));
    }

    private LoginData returnLoginInitParam(ShiroPrincipal principal) {
        this.tokenService.doGetAuthorizationInfo(principal);
        principal.setUserInfo(this.userInfoProviderService.getUserInfo(principal.getUserId()));
        this.initCompanyInfo(principal);
        Long userId = principal.getUserId();
        String username = principal.getUser().getUsername();
        String name = principal.getUser().getName();
        String ip = ServletUtils.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
        String secret = this.getTokenSecret(userId, principal.getUser().getPassword());
        String token = JwtUtil.createToken((String)username, (Long)userId, (String)name, (String)ip, (String)secret, (Long)Constant.WX_TOKEN_EXPIRE_TIME);
        String refreshToken = JwtUtil.createToken((String)username, (Long)userId, (String)secret, (Long)Constant.WX_TOKEN_REFRESH_TIME);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getWXLoginUserKey((Long)userId), (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)userId), (Object)secret, (long)Constant.WX_TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.HOURS);
        ShiroPrincipal principalDesensitization = ShiroUtil.getShiroPrincipalDesensitization(principal);
        return new LoginData(principalDesensitization, token, refreshToken);
    }

    public LoginData tokenRefresh(String refreshToken) {
        Long userId = JwtUtil.getUserId((String)refreshToken);
        String ip = ServletUtils.getRequest().getRemoteAddr();
        if (userId == null) {
            throw new ServiceException("refreshToken\u8fc7\u671f\uff01");
        }
        SysUser user = this.userProviderService.selectUserById(userId);
        if (user == null) {
            throw new ServiceException(Integer.valueOf(-1), "\u8d26\u53f7\u4e0d\u5b58\u5728\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01");
        }
        String secret = this.getTokenSecret(userId, user.getPassword());
        if (!JwtUtil.verify((String)refreshToken, (String)secret)) {
            throw new ServiceException(Integer.valueOf(-1), "token\u5237\u65b0\u5931\u8d25\uff01");
        }
        String newToken = JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), (String)user.getName(), (String)ip, (String)secret, (Long)Constant.TOKEN_EXPIRE_TIME);
        String newRefreshToken = JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), (String)secret, (Long)Constant.TOKEN_REFRESH_TIME);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)user.getId()), (Object)secret, (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
        return new LoginData(newToken, newRefreshToken);
    }

    private String getTokenSecret(Long userId, String password) {
        String secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getTokenSecret((Long)userId));
        if (secret == null) {
            this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)userId), (Object)password, (long)Constant.WX_TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.HOURS);
            return password;
        }
        return secret;
    }

    public boolean checkEmailCode(String email, String code) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey((String)email));
        if (Objects.isNull(modifyCode)) {
            log.info("checkEmailCode: email:{}", (Object)email);
            throw new ServiceException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)email);
        return Objects.equals(encryptCode, modifyCode.toString());
    }

    public boolean checkPhoneRegisterCode(String phone, String code) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getPhoneRegisterCodeKey((String)phone));
        if (Objects.isNull(modifyCode)) {
            throw new ServiceException("\u624b\u673a\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)phone);
        return Objects.equals(encryptCode, modifyCode.toString());
    }

    public boolean checkVcode(String key, String vcode, boolean isDelete) {
        Object vodeCache = null;
        if (isDelete) {
            vodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey((String)key));
            this.stringRedisTemplate.delete((Object)RedisKey.getVCodeKey((String)key));
        } else {
            vodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey((String)key));
        }
        if (Objects.isNull(vodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        return vcode.equalsIgnoreCase(vodeCache.toString());
    }

    public void cleanCache(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    private void initCompanyInfo(ShiroPrincipal principal) {
        List companyList = this.companyStaffProviderService.getByUidAndSource(principal.getUserId(), Integer.valueOf(2));
        if (CollectionUtils.isEmpty((Collection)companyList) || companyList.get(0) == null) {
            return;
        }
        principal.setCid(((CompanyListVo)companyList.get(0)).getId());
        principal.setCompanyName(((CompanyListVo)companyList.get(0)).getName());
    }

    @Generated
    public LoginService(StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> redisTemplate, TokenService tokenService) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisTemplate = redisTemplate;
        this.tokenService = tokenService;
    }
}

