/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.security.realms;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.RegisterToken;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.User;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class RegisterRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisterRealm.class);
    @Autowired(required=false)
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof RegisterToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        RegisterToken token = (RegisterToken)authenticationToken;
        String username = token.getUsername();
        log.debug("{} - token auth start...", (Object)username);
        SysUser user = this.tokenService.getUserByUsername(username, SysUserTypeEnum.USER.getValue());
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (token.getZlbUserId() != null && StringUtils.isBlank((CharSequence)user.getZlbUserId())) {
            this.tokenService.bindZlbUserId(user.getId(), token.getZlbUserId());
        }
        ShiroPrincipal loginUser = new ShiroPrincipal(new User(user));
        return new SimpleAuthenticationInfo((Object)loginUser, (Object)"", this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Object obj = super.getAvailablePrincipal(principals);
        if (!(obj instanceof ShiroPrincipal)) {
            return info;
        }
        ShiroPrincipal principal = (ShiroPrincipal)obj;
        info.setStringPermissions(principal.getPermissionsSet());
        info.setRoles(principal.getRoleSet());
        return info;
    }
}

