/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.supervise.service.sys.ISysLogService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogResourceEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ILogProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Aspect
@Component
@Order(value=1)
public class SysLogAopAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLogAopAspect.class);
    @DubboReference
    private ILogProviderService logProviderService;
    @DubboReference
    private ISysLogService superviseSysLogService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @DubboReference
    ISysCompanyStaffProviderService companyStaffProviderService;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Pointcut(value="@annotation(cn.smarthse.radiationTraining.core.framework.annotation.Log)")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
    }

    @Around(value="pointCut()")
    public Object aroundLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Log annotation = method.getAnnotation(Log.class);
        if (annotation != null) {
            ShiroPrincipal principal = (ShiroPrincipal)SecurityUtils.getSubject().getPrincipal();
            if (principal == null) {
                return result;
            }
            HttpServletRequest request = ServletUtils.getRequest();
            cn.smarthse.radiationTraining.modules.sys.entity.SysLog syslog = new cn.smarthse.radiationTraining.modules.sys.entity.SysLog();
            syslog.setUserId(principal.getUser().getId());
            syslog.setUsername(principal.getUser().getUsername());
            syslog.setFullname(principal.getUser().getName());
            syslog.setTitle(annotation.title());
            syslog.setResource(LogResourceEnum.WWW.getValue());
            syslog.setAreaId(principal.getUser().getAreaId());
            syslog.setType(annotation.type().value);
            syslog.setModuleType(annotation.logModule().moduleType);
            this.setParams(request, syslog);
            syslog.setRequestMethod(request.getMethod());
            syslog.setRemoteIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            syslog.setRequestUri(ServletUtils.getRequestUri((HttpServletRequest)request));
            syslog.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)request));
            syslog.setCreateBy(principal.getUser().getId());
            syslog.setUpdateBy(principal.getUser().getId());
            this.threadPoolTaskExecutor.execute(() -> this.logProviderService.addLog(syslog));
            try {
                if (annotation.type().equals((Object)LogTypeEnum.type_cas_login) || annotation.type().equals((Object)LogTypeEnum.type_login)) {
                    AreaModel areaById;
                    Long areaId = ShiroUtil.getLoginAreaId();
                    Long loginUserId = ShiroUtil.getLoginUserId();
                    Long cid = ShiroUtil.getCurCid();
                    SysLog superviseSysLog = new SysLog();
                    BeanUtils.copyProperties((Object)syslog, (Object)superviseSysLog);
                    superviseSysLog.setLogSource(Byte.valueOf(LogConstans.ONLINETRAINING.getValue().byteValue()));
                    List companyList = this.companyStaffProviderService.getByUidAndSource(loginUserId, null);
                    if (!CollectionUtil.isEmpty((Collection)companyList) && companyList.get(0) != null && ((CompanyListVo)companyList.get(0)).getAreaId() != null) {
                        areaId = ((CompanyListVo)companyList.get(0)).getAreaId();
                        cid = ((CompanyListVo)companyList.get(0)).getId();
                    }
                    if ((areaById = this.sysAreaService.getAreaById(areaId)) != null) {
                        SysArea area = new SysArea();
                        BeanUtils.copyProperties((Object)areaById, (Object)area);
                        superviseSysLog.setSysArea(area);
                    } else {
                        log.info("\u767b\u5f55\u65e5\u5fd7\u540c\u6b65\u5230\u6d59\u91cc\u536b\u4f01areaById\u4e3a\u7a7a");
                        superviseSysLog.setTitle(superviseSysLog.getTitle().concat("\u3010\u65e0\u6cd5\u660e\u786e\u884c\u653f\u533a\u5212\u3011"));
                    }
                    superviseSysLog.setCid(cid);
                    superviseSysLog.setType(Byte.valueOf((byte)1));
                    superviseSysLog.setCreateDate(new Date());
                    superviseSysLog.setUpdateDate(new Date());
                    this.superviseSysLogService.addLog(superviseSysLog);
                }
            }
            catch (Exception e) {
                log.error("\u767b\u5f55\u65e5\u5fd7\u540c\u6b65\u5230\u6d59\u91cc\u536b\u4f01\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        return result;
    }

    @AfterReturning(value="pointCut()")
    public void afterReturning(JoinPoint point) {
    }

    private void setParams(HttpServletRequest request, cn.smarthse.radiationTraining.modules.sys.entity.SysLog syslog) {
        if (syslog.getType().equals(LogTypeEnum.type_login.value) || request instanceof StandardMultipartHttpServletRequest) {
            return;
        }
        Map parameterMap = request.getParameterMap();
        syslog.setParams(StringUtils.substring((String)(CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : ServletUtils.getBody((ServletRequest)request)), (int)0, (int)255));
    }

    private boolean isCommonParam(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof MultipartFile) && !(arg instanceof HttpServletResponse) && !(arg instanceof HttpServletRequest)) continue;
            return false;
        }
        return true;
    }

    private void printParam(Object[] args, String url) {
        if (!this.isCommonParam(args)) {
            return;
        }
        if (url.contains("/login")) {
            return;
        }
        log.info("\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}", (Object)JSON.toJSONString((Object)args));
    }
}

