/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.controller.personalCenter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.unit.DataSize;
import cn.hutool.http.HttpUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVoH5;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxCompanyListVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.converter.H5Converter;
import cn.smarthse.radiationTraining.modules.wx.service.thrid.BaiduApiService;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/wqxx/personalCenter"})
@Validated
public class WqxxPersonalCenterController
extends ControllerSupport {
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;
    private final OssClientBean ossClientBean;
    private final BaiduApiService baiduApiService;
    private final H5Converter converter;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ISysCompanyStaffProviderService companyStaffProviderService;

    @PostMapping(value={"/getPersonalInfoH5"})
    public ResponseData<PersonalUserVoH5> getPersonalInfoH5() {
        PersonalUserVoH5 personalUserVoH5 = this.converter.PersonalUserVo2PersonalUserVoH5(this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId()));
        personalUserVoH5.setIdcardTypeName(IdcardTypeEnum.getName((Integer)personalUserVoH5.getIdcardType()));
        personalUserVoH5.setIdcard(StringUtils.desensitizationCertificateNumber((String)personalUserVoH5.getIdcard()));
        personalUserVoH5.setName(DesensitizationUtils.desensitized((CharSequence)personalUserVoH5.getName(), (DesensitizationType)DesensitizationType.NAME));
        personalUserVoH5.setEmail(DesensitizationUtils.desensitized((CharSequence)personalUserVoH5.getEmail(), (DesensitizationType)DesensitizationType.EMAIL));
        return ResponseData.success((Object)this.converter.PersonalUserVo2PersonalUserVoH5(this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId())));
    }

    @PostMapping(value={"forbiddenSelf"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenParam param) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(ShiroUtil.getLoginUserId());
        param.setIdList(null);
        param.setIdList(ids);
        param.setIsForbidden(Integer.valueOf(1));
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @RequestLimit(maxCount=1000, second=43200)
    @RequestMapping(value={"faceAuth"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<Boolean> faceAuth(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) {
        Long userId = ShiroUtil.getLoginUserId();
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.FACE_AUTH.getPath();
        String realPath = this.ossClientBean.getLocal() + uploadDir;
        UploadFileParameter up = new UploadFileParameter();
        up.setRequest(request);
        up.setUploadDir(uploadDir);
        up.setRealPath(realPath);
        up.setFileResource(Integer.valueOf(FileResourceEnum.radiation_training.getValue()));
        FileUploadSimple.upload_pluploader((UploadFileParameter)up);
        String image1 = "";
        String image2 = "";
        String photoUrl = this.userProviderService.getPhotoUrl(userId);
        if (StringUtils.isBlank((CharSequence)photoUrl)) {
            return ResponseData.success((String)"\u8bc1\u4ef6\u7167\u4e0d\u5b58\u5728\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
        }
        try {
            int image2Length;
            long twoMb = DataSize.ofMegabytes((long)2L).toBytes();
            long tarMb = twoMb * 95L / 100L;
            image1 = Base64Util.encode((byte[])Util.readFileByBytes((String)(up.getRealPath() + File.separator + up.getFileName())));
            image2 = Base64Util.encode((byte[])HttpUtil.downloadBytes((String)photoUrl));
            long image1Length = up.getFile().length();
            if (image1Length > twoMb) {
                BigDecimal num1 = new BigDecimal(tarMb);
                BigDecimal num2 = new BigDecimal(image1Length);
                Image scaleImage1 = ImgUtil.scale((Image)ImgUtil.toImage((String)image1), (float)num1.divide(num2, 2, RoundingMode.DOWN).floatValue());
                image1 = ImgUtil.toBase64((Image)scaleImage1, (String)"jpg");
            }
            if ((long)(image2Length = HttpUtil.downloadBytes((String)photoUrl).length) > twoMb) {
                BigDecimal num1 = new BigDecimal(tarMb);
                BigDecimal num2 = new BigDecimal(image2Length);
                Image scaleImage2 = ImgUtil.scale((Image)ImgUtil.toImage((String)image2), (float)num1.divide(num2, 2, RoundingMode.DOWN).floatValue());
                image2 = ImgUtil.toBase64((Image)scaleImage2, (String)"jpg");
            }
        }
        catch (IOException e) {
            this.logger.error("IOException: ", (Throwable)e);
        }
        if (this.baiduApiService.doFaceMatch(image1, image2)) {
            return ResponseData.success((String)"\u8ba4\u8bc1\u901a\u8fc7\uff01", (Object)true);
        }
        return ResponseData.success((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
    }

    @GetMapping(value={"searchCompanyListForWqxx"})
    public ResponseData<LayuiGridData<WxCompanyListVo>> searchCompanyListForWqxx(String companyName, Integer pageNum, Integer pageSize) {
        CompanySuperviseSearchModel param = new CompanySuperviseSearchModel();
        param.setSystemDeploymentSource(SystemDeploymentSourceEnum.ONLINE_TRAINING.getCode());
        param.setName(companyName);
        PageInfo list = this.companyProvideBySuperviseService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(param, pageNum.intValue(), pageSize.intValue(), Boolean.valueOf(false));
        if (CollUtil.isEmpty((Collection)list.getList())) {
            return new ResponseData();
        }
        ArrayList<WxCompanyListVo> rstList = new ArrayList<WxCompanyListVo>(list.getList().size());
        for (CompanySuperviseModel vo : list.getList()) {
            rstList.add(new WxCompanyListVo(vo.getCid(), vo.getName(), vo.getAreaId(), vo.getBelongType()));
        }
        return new ResponseData((Object)new LayuiGridData(rstList, pageNum, pageSize, Integer.valueOf((int)list.getTotal()), null));
    }

    @GetMapping(value={"searchCompanyStaffList"})
    public ResponseData<List<CompanyListVo>> searchCompanyStaffList() {
        return new ResponseData((Object)this.companyStaffProviderService.getByUidAndSource(ShiroUtil.getLoginUserId(), null));
    }

    @PostMapping(value={"/flushCompanyId"})
    public ResponseData<String> flushOrgId(@NotNull Long cid, @NotNull String companyName) {
        ShiroUtil.flushCid(cid, companyName);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getWXLoginUserKey((Long)ShiroUtil.getLoginUserId()), (Object)ShiroUtil.getShiroPrincipal(), Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        this.companyStaffProviderService.saveWithSource(cid, ShiroUtil.getLoginUserId(), ShiroUtil.getLoginUserId(), Integer.valueOf(2));
        return ResponseData.success();
    }

    @Generated
    public WqxxPersonalCenterController(OssClientBean ossClientBean, BaiduApiService baiduApiService, H5Converter converter, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.ossClientBean = ossClientBean;
        this.baiduApiService = baiduApiService;
        this.converter = converter;
        this.redisTemplate = redisTemplate;
    }
}

