/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.service.thrid;

import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.MatchRequest;
import java.util.ArrayList;
import lombok.Generated;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class BaiduApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaiduApiService.class);
    private final RedisTemplate<String, Integer> redisTemplate;
    private final AipFace client;
    private static final int MAX_REQUEST_QUEUE_SIZE = 100;
    private static final int MAX_REQUEST_SIZE = 10;
    private static final String faceMatch_KEY_NAME = "LIMIT:baidu:FaceMatch";

    public boolean doFaceMatch(String image1, String image2) {
        this.redisTemplate.boundValueOps((Object)faceMatch_KEY_NAME).increment();
        boolean b = false;
        try {
            b = this.faceMatch(image1, image2);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
        this.redisTemplate.boundValueOps((Object)faceMatch_KEY_NAME).decrement();
        return b;
    }

    public boolean faceMatch(String image1, String image2) {
        MatchRequest req1 = new MatchRequest(image1, "BASE64");
        MatchRequest req2 = new MatchRequest(image2, "BASE64");
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        JSONObject res = this.client.match(requests);
        try {
            double score = res.getJSONObject("result").getDouble("score");
            log.debug("\u4eba\u8138\u76f8\u4f3c\u5ea6: {}", (Object)score);
            return score > 30.0;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public boolean doLimit() {
        int retry_times = 0;
        do {
            if (this.limit()) {
                return true;
            }
            try {
                Thread.sleep(500L);
                ++retry_times;
            }
            catch (InterruptedException e) {
                log.error("InterruptedException\uff1a", (Throwable)e);
            }
        } while (retry_times < 10);
        return false;
    }

    public boolean limit() {
        Integer count = (Integer)this.redisTemplate.boundValueOps((Object)faceMatch_KEY_NAME).get();
        return count == null || count < 10;
    }

    @Generated
    public BaiduApiService(RedisTemplate<String, Integer> redisTemplate, AipFace client) {
        this.redisTemplate = redisTemplate;
        this.client = client;
    }
}

