/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.service.redis;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private static final int DEFAULT_ACQUIRY_RESOLUTION_MILLIS = 100;
    public static final String LOCK_PREFIX = "LOCK_";
    private final RedisTemplate<String, Object> redisTemplate;
    private int expireMsecs = 60000;
    private int timeoutMsecs = 10000;

    public String get(String key) {
        Object obj = null;
        try {
            obj = this.redisTemplate.execute(connection -> {
                StringRedisSerializer serializer = new StringRedisSerializer();
                byte[] data = connection.get(serializer.serialize(key));
                connection.close();
                if (data == null) {
                    return null;
                }
                return serializer.deserialize(data);
            });
        }
        catch (Exception e) {
            log.error("get redis error, key : {}", (Object)key);
        }
        return obj != null ? obj.toString() : null;
    }

    public boolean setNX(String key, String value) {
        Object obj = null;
        try {
            obj = this.redisTemplate.execute(connection -> {
                StringRedisSerializer serializer = new StringRedisSerializer();
                Boolean success = connection.setNX(serializer.serialize(key), serializer.serialize(value));
                connection.close();
                return success;
            });
        }
        catch (Exception e) {
            log.error("setNX redis error, key : {}", (Object)key);
        }
        return obj != null ? (Boolean)obj : false;
    }

    private String getSet(String key, String value) {
        Object obj = null;
        try {
            obj = this.redisTemplate.execute(connection -> {
                StringRedisSerializer serializer = new StringRedisSerializer();
                byte[] ret = connection.getSet(serializer.serialize(key), serializer.serialize(value));
                connection.close();
                return serializer.deserialize(ret);
            });
        }
        catch (Exception e) {
            log.error("setNX redis error, key : {}", (Object)key);
        }
        return obj != null ? (String)obj : null;
    }

    public boolean lock(String lockKey) {
        try {
            lockKey = LOCK_PREFIX + lockKey;
            for (int timeout = this.timeoutMsecs; timeout >= 0; timeout -= 100) {
                String oldValueStr;
                long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
                String expiresStr = String.valueOf(expires);
                if (this.setNX(lockKey, expiresStr)) {
                    return true;
                }
                String currentValueStr = this.get(lockKey);
                if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis() && (oldValueStr = this.getSet(lockKey, expiresStr)) != null && oldValueStr.equals(currentValueStr)) {
                    return true;
                }
                Thread.sleep(100L);
            }
            return false;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return false;
        }
    }

    public void unlock(String lockKey) {
        lockKey = LOCK_PREFIX + lockKey;
        this.redisTemplate.delete((Object)lockKey);
    }

    @Generated
    public RedisLock(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

