/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.service.order.impl;

import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.AlipayProperties;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderService;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ITuCertificateProviderService;
import cn.smarthse.radiationTraining.modules.wx.service.order.IPayService;
import cn.smarthse.radiationTraining.modules.wx.service.order.payNotify.PayNotifyExecuteFactory;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundApplyModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements IPayService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AlipayProperties options;
    private final PayNotifyExecuteFactory payNotifyExecuteFactory;
    private final RedissonClient redissonClient;
    @DubboReference
    private ISysOrderService sysOrderService;
    @DubboReference
    private ITuCertificateProviderService certProviderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pay_callback(SysOrder order) {
        this.logger.info("\u8ba2\u5355\u4e1a\u52a1\u56de\u8c03-out_trade_no\uff1a{}-\u56de\u8c03\u5f00\u59cb", (Object)order.getId());
        String lockKey = String.format("LOCK:PAY_NOTIFY:%s", order.getOrderNo());
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            if (lock.tryLock(10L, TimeUnit.MINUTES)) {
                SysOrder sysOrder = (SysOrder)this.sysOrderService.getById((Serializable)order.getId());
                if (OrderPayStateEnum.PAY.getValue().equals(sysOrder.getPayState())) {
                    this.logger.info("\u652f\u4ed8\u56de\u8c03-out_trade_no\uff1a{}-payState\uff1a{}-\u8ba2\u5355\u5df2\u652f\u4ed8\u65e0\u9700\u518d\u6b21\u56de\u8c03", (Object)sysOrder.getOrderNo(), (Object)order.getPayState());
                    return;
                }
                this.sysOrderService.updateById((Object)order);
                this.payNotifyExecuteFactory.invokePayNotify(order);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u4e1a\u52a1\u56de\u8c03\uff1aexception", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        this.logger.info("\u8ba2\u5355\u4e1a\u52a1\u56de\u8c03\uff1a{}-\u56de\u8c03\u5b8c\u6210", (Object)order.getId());
    }

    @Override
    public boolean check_from_AlipayTradeQuery(Long outTradeNo, SysOrder order) {
        this.logger.info("out_trade_no\uff1a{}-\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u6821\u9a8c", (Object)outTradeNo);
        if (outTradeNo == null || order == null || !order.getPayState().equals(OrderPayStateEnum.UN_PAY.getValue())) {
            return false;
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.options.gatewayHost, this.options.appId, this.options.merchantPrivateKey, "json", "UTF-8", this.options.alipayPublicKey, this.options.signType);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(outTradeNo.toString());
        request.setBizModel((AlipayObject)model);
        AlipayTradeQueryResponse response = null;
        for (int i = 0; i < 4; ++i) {
            try {
                response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
                if (response.isSuccess()) break;
                this.logger.info("out_trade_no\uff1a{}-\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u6821\u9a8c\u5931\u8d25-\u7ed3\u679c\uff1a{}", (Object)outTradeNo, (Object)response.getMsg());
                continue;
            }
            catch (AlipayApiException e) {
                e.printStackTrace();
            }
        }
        boolean result = "TRADE_SUCCESS".equals(response.getTradeStatus()) && order.getGoodsPrice().compareTo(new BigDecimal(response.getTotalAmount())) == 0;
        this.logger.info("out_trade_no\uff1a{}-\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u6821\u9a8c-\u7ed3\u679c\uff1a{}", (Object)outTradeNo, (Object)result);
        return result;
    }

    @Override
    public boolean rsaCheckV1(Map<String, String> params) {
        this.logger.info("out_trade_no\uff1a{}-\u652f\u4ed8\u5b9d\u9a8c\u7b7e", (Object)params.get("out_trade_no"));
        boolean alipayRSACheckedV2 = false;
        try {
            alipayRSACheckedV2 = AlipaySignature.rsaCheckV1(params, (String)this.options.alipayPublicKey, (String)"utf-8", (String)"RSA2");
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return false;
        }
        this.logger.info("out_trade_no\uff1a{}-\u652f\u4ed8\u5b9d\u9a8c\u7b7e\u7ed3\u679c\uff1a{}", (Object)params.get("out_trade_no"), (Object)alipayRSACheckedV2);
        return alipayRSACheckedV2;
    }

    @Override
    public Map<String, String> getPayResult_alipay(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Set entrySet = request.getParameterMap().entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            int valLen = values.length;
            if (valLen == 1) {
                retMap.put(name, values[0]);
                continue;
            }
            if (valLen > 1) {
                StringBuilder sb = new StringBuilder();
                for (String val : values) {
                    sb.append(",").append(val);
                }
                retMap.put(name, sb.substring(1));
                continue;
            }
            retMap.put(name, "");
        }
        return retMap;
    }

    @Override
    public boolean refunds_alipay(SysOrder order, BigDecimal refundAmount, String refundReason) {
        this.logger.info("\u652f\u4ed8\u5b9d\u652f\u4ed8-\u9000\u6b3e-\u8ba2\u5355:{}-\u5f00\u59cb\u9000\u6b3e-\u9000\u6b3e\u539f\u56e0:{}", (Object)order.getId(), (Object)refundReason);
        Long tradeNo = order.getId();
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.options.gatewayHost, this.options.appId, this.options.merchantPrivateKey, "json", "UTF-8", this.options.alipayPublicKey, this.options.signType);
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        AlipayTradeRefundApplyModel model = new AlipayTradeRefundApplyModel();
        model.setOutTradeNo(tradeNo.toString());
        model.setRefundAmount(refundAmount.toString());
        model.setRefundReason(refundReason);
        request.setBizModel((AlipayObject)model);
        AlipayTradeRefundResponse response = null;
        try {
            response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                String outTradeNo = response.getOutTradeNo();
                String refundFee = response.getRefundFee();
                this.logger.info("\u652f\u4ed8\u5b9d\u652f\u4ed8-\u9000\u6b3e-outTradeNo:{}-refundFee:{}", (Object)outTradeNo, (Object)refundFee);
                order.setPayState(OrderPayStateEnum.REFUND.getValue());
                return true;
            }
            this.logger.info("\u652f\u4ed8\u5b9d\u652f\u4ed8-\u9000\u6b3e-\u9000\u6b3e\u5931\u8d25-subMsg:{}", (Object)response.getSubMsg());
            return false;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Generated
    public PayServiceImpl(AlipayProperties options, PayNotifyExecuteFactory payNotifyExecuteFactory, RedissonClient redissonClient) {
        this.options = options;
        this.payNotifyExecuteFactory = payNotifyExecuteFactory;
        this.redissonClient = redissonClient;
    }
}

