/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.uc;

import cn.hutool.extra.servlet.ServletUtil;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.uploader.FileMD5;
import cn.smarthse.radiationTraining.core.framework.uploader.FileResourceEnum;
import cn.smarthse.radiationTraining.core.framework.uploader.FileUploadSimple;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFileParameter;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.core.framework.utils.VideoUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.training.param.TuCertificateModel;
import cn.smarthse.radiationTraining.modules.training.param.training.MyCertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ITuCertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertTrainVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.MyCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6211\u7684\u8bc1\u4e66"})
@ApiSupport(order=30, author="\u5434\u5c0f\u5f3a")
@RestController
@RequestMapping(value={"/myCertificates"})
public class MyCertificatesController
extends ControllerSupport {
    private static final String UPLOADDIR = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.Common.getPath();
    @DubboReference
    private ITuCertificateProviderService tuCertificateProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    private final OssClientBean ossClientBean;

    @ApiOperation(value="\u6211\u7684\u8bc1\u4e66-\u5217\u8868\u6570\u636e")
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<MyCertificateVo>> getList(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateList(param));
    }

    @ApiOperation(value="\u6211\u7684\u8bc1\u4e66-\u7edf\u8ba1")
    @GetMapping(value={"/getList/count"})
    public ResponseData<CertTrainVo> getListCount(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateListCount(param));
    }

    @ApiOperation(value="\u6211\u7684\u8bc1\u4e66-\u57fa\u7840\u6570\u636e")
    @PostMapping(value={"/addCertificate"})
    public ResponseData addCertificate(@RequestBody IdParam idParam) {
        this.tuCertificateProviderService.addCertificate(idParam.getId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u6211\u7684\u8bc1\u4e66-\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bc1\u4e66id", required=true, dataType="Long", paramType="query")})
    @GetMapping(value={"getDetailById"})
    public ResponseData<TuCertVo> getDetail(Long id) {
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateDetailById(id, ShiroUtil.getLoginUserId()));
    }

    @ApiOperation(value="\u6211\u7684\u8bc1\u4e66-\u5df2\u751f\u6210\u8bc1\u4e66\u57f9\u8bad\u5217\u8868(web\u7aef)")
    @GetMapping(value={"/getHasCetTrainList"})
    public ResponseData<LayuiGridData<CertTrainVo>> getHasCetTrainList(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getHasCetTrainList(param));
    }

    @ApiOperation(value="\u6211\u7684\u8bc1\u4e66-\u57f9\u8bad\u5bf9\u5e94\u8bc1\u4e66(web\u7aef)")
    @GetMapping(value={"/getTrainCetList"})
    public ResponseData<List<MyCertificateVo>> getTrainCetList(MyCertificateParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCertificateProviderService.getTrainCetList(param));
    }

    @ApiOperation(value="\u751f\u6210pdf\u8bc1\u4e66\uff08\u9ed8\u8ba45\u79d2\u53ef\u8bbf\u95ee1\u6b21\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bc1\u4e66id", required=true)})
    @RequestLimit(second=300, maxCount=1, msg="\u8bf75\u5206\u949f\u540e\u91cd\u8bd5\uff01")
    @GetMapping(value={"/generateCertificate"})
    public ResponseData<TuCertVo> generateCertificate(Long id) {
        return ResponseData.success((Object)this.tuCertificateProviderService.genCertFile(id));
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8bc1\u4e66,\u5e76\u53d1\u9001\u90ae\u7bb1")
    @ApiImplicitParam(name="id", value="\u8bc1\u4e66id", required=true)
    @RequestLimit(second=300, maxCount=1, msg="\u8bf75\u5206\u949f\u540e\u91cd\u8bd5\uff01")
    @GetMapping(value={"/SendCertificate"})
    public ResponseData SendCertificate(Long id) {
        this.tuCertificateProviderService.SendCertificate(id);
        return ResponseData.success();
    }

    private void checkCertificateInfo(TuCertificateModel model) {
        if (StringUtils.isEmpty((CharSequence)model.getTrainingName())) {
            throw new ServiceException("\u7f3a\u5c11\u57f9\u8bad\u540d\u79f0\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53bb\u5b8c\u5584");
        }
        if (StringUtils.isEmpty((CharSequence)model.getName())) {
            throw new ServiceException("\u7f3a\u5c11\u59d3\u540d\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getSex())) {
            throw new ServiceException("\u7f3a\u5c11\u6027\u522b\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getIdcard())) {
            throw new ServiceException("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getEducation())) {
            throw new ServiceException("\u7f3a\u5c11\u6559\u80b2\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getImg())) {
            throw new ServiceException("\u7f3a\u5c11\u56fe\u7247\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getImg2())) {
            throw new ServiceException("\u7f3a\u5c11\u516c\u7ae0\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53bb\u5b8c\u5584");
        }
        if (StringUtils.isEmpty((CharSequence)model.getWorkUnit())) {
            throw new ServiceException("\u7f3a\u5c11\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getTrainingName())) {
            throw new ServiceException("\u7f3a\u5c11\u57f9\u8bad\u5185\u5bb9\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53bb\u5b8c\u5584");
        }
        if (StringUtils.isEmpty((CharSequence)model.getScore())) {
            throw new ServiceException("\u7f3a\u5c11\u8003\u8bd5\u6210\u7ee9\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getRadiationWork())) {
            throw new ServiceException("\u7f3a\u5c11\u5de5\u4f5c\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getOccExposureCode())) {
            throw new ServiceException("\u7f3a\u5c11\u804c\u4e1a\u7167\u5c04\u4ee3\u7801\u4fe1\u606f\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getWorkBeginTime())) {
            throw new ServiceException("\u7f3a\u5c11\u653e\u5c04\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u53bb\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)model.getTrainingName())) {
            throw new ServiceException("\u7f3a\u5c11\u57f9\u8bad\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u57f9\u8bad\u5355\u4f4d\u5b8c\u5584\u4fe1\u606f");
        }
        if (!VideoUtils.isImagesTrue((String)model.getImg()).booleanValue()) {
            throw new ServiceException("\u8bc1\u4ef6\u7167\u5931\u6548\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!VideoUtils.isImagesTrue((String)model.getImg2()).booleanValue()) {
            throw new ServiceException("\u516c\u7ae0\u7167\u5931\u6548\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
    }

    SysFileModel uploadBackstage(HttpServletRequest request, File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), (InputStream)inputStream);
        String uploadDir = UPLOADDIR.replace("\\", "/");
        int fileResource = FileResourceEnum.radiation_training.getValue();
        String hashCode = FileMD5.getFileMD5((byte[])multipartFile.getBytes());
        String originalFilename = multipartFile.getName();
        String fileExt = FilenameUtils.getExtension((String)multipartFile.getName());
        Long filesize = multipartFile.getSize();
        String fileName = file.getPath().substring(file.getPath().lastIndexOf("\\") + 1);
        fileName = FileUploadSimple.getNumberName((String)fileName, (String)fileExt);
        String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        String ossUrl = null;
        if (this.ossClientBean.isAsynch()) {
            String fullname = StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)originalFilename)) ? originalFilename + "." + fileExt : originalFilename;
            ossUrl = this.ossClientBean.OSSPutObject(fileName, file, uploadDir, fullname);
            this.logger.info("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + this.ossClientBean.getUrl(ossUrl));
        }
        SysFileModel sysFileModel = new SysFileModel();
        sysFileModel.setResource(Integer.valueOf(fileResource)).setFileName(originalFilename).setFileSize(filesize + "").setFileExt(fileExt).setFileHash(hashCode).setCreatorIp(ip).setFullOssUrl(this.ossClientBean.getUrl(ossUrl)).setOssUrl(ossUrl);
        this.sysFileProvideService.addSysFile(sysFileModel, ShiroUtil.getLoginUserId());
        ((InputStream)inputStream).close();
        return sysFileModel;
    }

    @Generated
    public MyCertificatesController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

