/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.trainingCenter;

import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RemoveEnrollInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ITuCertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.MyCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxCompanyListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxTrainCourseGroupVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57f9\u8bad\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"/train"})
public class WxTrainingController
extends ControllerSupport {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser iTrainingProviderServiceForUser;
    @DubboReference
    private ITuCertificateProviderService tuCertificateProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;

    @ApiOperation(value="\u62a5\u540d\u4e8c\u7ef4\u7801\u89e3\u6790")
    @PostMapping(value={"/qrcode/analysis"})
    public ResponseData parsingQRCode(String qrcode) {
        return ResponseData.success((String)this.enrollProviderService.parsingQRCode(qrcode));
    }

    @ApiOperationSupport(order=1)
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u5217\u8868")
    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<UserMyTrainListVo>> getTrainingList(UserMyTrainSearchParam param) {
        ShiroPrincipal shiroPrincipal = ShiroUtil.getShiroPrincipal();
        param.setUid(shiroPrincipal.getUserId());
        param.setIsGetBackTrain(Integer.valueOf(1));
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainPageListForUser(param));
    }

    @ApiOperationSupport(order=5)
    @ApiOperation(value="\u67e5\u770b\u57f9\u8bad\u57fa\u672c\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId")})
    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<TrainingBaseInfoVo> getMyTrainingBaseInfo(Long tid, Long enrollDetailId) {
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainingBaseInfoForWx(tid, uid, enrollDetailId));
    }

    @ApiOperationSupport(order=10)
    @ApiOperation(value="\u83b7\u53d6\u62a5\u540d\u6240\u9700\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId")})
    @GetMapping(value={"getEnrollNeededInfo"})
    public ResponseData<TrainingBaseInfoVo> getEnrollNeededInfo(Long tid) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getEnrollNeededInfo(tid));
    }

    @ApiOperationSupport(order=12)
    @ApiOperation(value="\u63d0\u4f9b\u5355\u4f4d\u5217\u8868")
    @GetMapping(value={"searchCompanyList"})
    public ResponseData<LayuiGridData<WxCompanyListVo>> searchCompanyList(String companyName, Integer pageNum, Integer pageSize) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.searchCompanyList(ShiroUtil.getLoginUserId(), companyName, pageNum, pageSize));
    }

    @ApiOperationSupport(order=13)
    @ApiOperation(value="\u63d0\u4f9b\u5355\u4f4d\u5217\u8868 - \u653e\u5c04\u536b\u751f\u5728\u7ebf\u533b\u9662\u5355\u4f4d(\u5305\u62ec\u975e\u533b\u653e\u5c04\u5355\u4f4d)")
    @GetMapping(value={"searchCompanyListForRho"})
    public ResponseData<LayuiGridData<WxCompanyListVo>> searchCompanyListForRho(String companyName, Integer pageNum, Integer pageSize) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.searchCompanyListForRho(ShiroUtil.getLoginUserId(), companyName, pageNum, pageSize));
    }

    @ApiOperationSupport(order=14)
    @ApiOperation(value="\u662f\u5426\u6709\u53ef\u62a5\u540d\u7684\u57f9\u8bad")
    @GetMapping(value={"isCouldEnroll"})
    public ResponseData<Boolean> isCouldEnroll(TrainingSearchParam param) {
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.isCouldEnroll(param));
    }

    @ApiOperationSupport(order=15)
    @ApiOperation(value="\u67e5\u770b\u62a5\u540d\u5217\u8868")
    @GetMapping(value={"getCouldEnrollList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getCouldEnrollList(TrainingSearchParam param) {
        if (param.getTrainTarget() == null) {
            param.setTrainTarget(Integer.valueOf(0));
        } else if (param.getTrainTarget().equals(TrainTargetEnum.RAY_WORK.getValue())) {
            if (ShiroUtil.getUserLoginFrom() == 1) {
                param.setTrainType("\u521d\u6b21\u57f9\u8bad");
            }
            if (ShiroUtil.getUserLoginFrom() == 2) {
                param.setTrainType("\u7ee7\u7eed\u6559\u80b2");
            }
        }
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getCouldEnrollList(param));
    }

    @ApiOperationSupport(order=16)
    @ApiOperation(value="\u67e5\u770b\u53ef\u62a5\u540d\u57f9\u8bad-\u8be6\u60c5")
    @GetMapping(value={"getCouldEnrollInfo"})
    public ResponseData<TrainingListVo> getCouldEnrollInfo(TrainingSearchParam param) {
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getCouldEnrollInfo(param));
    }

    @ApiOperationSupport(order=20)
    @ApiOperation(value="\u57f9\u8bad\u8bfe\u7a0b\u5217\u8868")
    @GetMapping(value={"getTrainCourseList"})
    public ResponseData<List<WxTrainCourseGroupVo>> getTrainCourseListForWx(Long tid) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainCourseListForWx(tid));
    }

    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u83b7\u53d6\u57f9\u8bad\u4e0b\u7684\u8bc1\u4e66\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u540d\u8be6\u60c5id")})
    @GetMapping(value={"getCertList"})
    public ResponseData<List<MyCertificateVo>> getCertList(Long id) {
        return new ResponseData((Object)this.tuCertificateProviderService.getMyCertificateList(id));
    }

    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u83b7\u53d6\u4e13\u4e1a\u57f9\u8bad\u57fa\u7840\u76ee\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u57f9\u8badid")})
    @GetMapping(value={"getBaseCourseCataLogue"})
    public ResponseData<List<CourseGroupCatalogueVo>> getBaseCourseCataLogue(Long id) {
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getBaseCourseCataLogue(id));
    }

    @ApiOperationSupport(order=200)
    @ApiOperation(value="\u5220\u9664\u62a5\u540d\u4fe1\u606f\uff08\u5305\u62ec\u5b66\u4e60\u3001\u8bc1\u4e66\u8bb0\u5f55\uff09")
    @Log(title="\u4e2a\u4eba\u7528\u6237\u5217\u8868-\u5220\u9664\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_person, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"staffToRmEnrollInfo"})
    public ResponseData staffToRmEnrollInfo(RemoveEnrollInfoParam param) {
        this.enrollProviderService.staffToRmEnrollInfo(param);
        return ResponseData.success();
    }

    @ApiOperationSupport(order=1000)
    @ApiOperation(value="\u91cd\u65b0\u5efa\u7acb\u516c\u53f8\u5458\u5de5\u5173\u7cfb")
    @GetMapping(value={"reBuildAllRelationship"})
    public ResponseData getTrainingList(String pwd) {
        this.enrollProviderService.reBuildAllRelationship(pwd);
        return ResponseData.success();
    }

    @ApiOperation(value="\u516c\u53f8\u5907\u7528\u540c\u6b65\uff08\u6d4b\u8bd5\u7528\uff09")
    @PostMapping(value={"/backup/sync"})
    public ResponseData test(Date time, String pwd) {
        if (!"asdfjijzjwmw".equals(pwd)) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.hseCompanyProviderService.updateNewestInfoFromSource(time);
        return ResponseData.success();
    }

    @ApiOperation(value="\u516c\u53f8\u5907\u7528\u8868\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58")
    @GetMapping(value={"/updateTime/set"})
    public ResponseData setUpdateTime(Date unitTime, Date ogrTime, String pwd) {
        if (!"asdfjijzjwmw".equals(pwd)) {
            throw new ServiceException("\u5f02\u5e38");
        }
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.redisTemplate.opsForValue().set((Object)RedisKey.getUpUnitTimeKey(), (Object)dateformat.format(unitTime));
        this.redisTemplate.opsForValue().set((Object)RedisKey.getUpOrgTimeKey(), (Object)dateformat.format(ogrTime));
        return ResponseData.success();
    }
}

