/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.trainingCenter;

import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderService;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RestoreStuRecordParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.ExamAlertInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TraningProgressVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(author="\u9648\u4eae")
@Api(tags={"\u5c0f\u7a0b\u5e8f-\u5b66\u4e60\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/learn"})
public class WxCourseController {
    @DubboReference
    private ITuCourseProviderService tuCourseProviderService;
    @DubboReference
    private ISysOrderService sysOrderService;
    @DubboReference
    private ITrainingProviderServiceForUser iTrainingProviderServiceForUser;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u66f4\u65b0\u65f6\u957f")
    @PostMapping(value={"updateStuDuration", "updateStuDuration/major", "updateDuration/precise", "updateStuDuration/org"})
    public ResponseData updateStuDuration(@RequestBody UpdateDurationParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        this.tuCourseProviderService.updateStuDuration(param);
        return ResponseData.success((String)"\u6210\u529f");
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u83b7\u53d6\u9876\u7ea7\u76ee\u5f55\uff08\u4e13\u4e1a\u57f9\u8bad\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badId"), @ApiImplicitParam(name="detailId", value="\u62a5\u540did"), @ApiImplicitParam(name="stuStatus", value="\u5b66\u4e60\u5217\u8868\uff080\u5f85\u5b66\u4e602\u5df2\u5b66\u4e60 -1\u5168\u90e8\uff09")})
    @GetMapping(value={"getCourseCataLogue"})
    public ResponseData<List<CourseGroupCatalogueVo>> getCourseCataLogueForMajor(Long tid, Long detailId, Integer stuStatus) {
        this.tuCourseProviderService.checkOwner(detailId, null, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getCourseCataLogueForMajor(tid, detailId, stuStatus, ShiroUtil.getLoginUserId()));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u83b7\u53d6\u9876\u7ea7\u76ee\u5f55\uff08\u7cbe\u51c6\u57f9\u8bad\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="enrollDetailId", value="\u62a5\u540d\u8be6\u60c5id"), @ApiImplicitParam(name="stuStatus", value="\u5b66\u4e60\u5217\u8868\uff080\u5f85\u5b66\u4e602\u5df2\u5b66\u4e60 -1\u5168\u90e8\uff09")})
    @GetMapping(value={"getCourseCataLogueForPrecise"})
    public ResponseData<List<CourseItemCatalogueVo>> getCourseCataLogueForPrecise(Long enrollDetailId, Integer stuStatus) {
        this.tuCourseProviderService.checkOwner(enrollDetailId, null, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getCourseCataLogueForPrecise(enrollDetailId, stuStatus));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u83b7\u53d6\u9876\u7ea7\u76ee\u5f55\uff08\u670d\u52a1\u673a\u6784\u57f9\u8bad\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="enrollDetailId", value="\u62a5\u540d\u8be6\u60c5id"), @ApiImplicitParam(name="stuStatus", value="\u5b66\u4e60\u5217\u8868\uff080\u5f85\u5b66\u4e602\u5df2\u5b66\u4e60 -1\u5168\u90e8\uff09")})
    @GetMapping(value={"getCourseCataLogueForOrg"})
    public ResponseData<List<CourseItemCatalogueVo>> getCourseCataLogueForOrg(Long tid, Long enrollDetailId, Integer stuStatus) {
        this.tuCourseProviderService.checkOwner(enrollDetailId, null, ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.tuCourseProviderService.getCourseCataLogueForOrg(tid, enrollDetailId, stuStatus));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u8bfe\u7a0b\u8be6\u60c5\uff08\u4e13\u4e1a\u3001\u670d\u52a1\u673a\u6784\u3001\u7cbe\u51c6\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="traningCourseId", value="\u57f9\u8bad\u8bfe\u7a0bid")})
    @GetMapping(value={"getCourseItem2"})
    public ResponseData<TrainingCourseItemVo> getCourseItem(Long tuCoruseId) {
        this.tuCourseProviderService.checkOwner(null, tuCoruseId, ShiroUtil.getLoginUserId());
        ResponseData responseData = this.iTrainingProviderServiceForUser.getCourseItem(tuCoruseId);
        TrainingCourseItemVo result = (TrainingCourseItemVo)responseData.getResult();
        if (result != null && result.getVideoDurationSec() != null && result.getStuStatus() != null && result.getStuStatus().equals(2)) {
            result.setStuDurationSec(result.getVideoDurationSec());
        }
        return responseData;
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u8bfe\u7a0b\u8be6\u60c5\uff08\u4e13\u4e1a\u3001\u670d\u52a1\u673a\u6784\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="traningCourseId", value="\u57f9\u8bad\u8bfe\u7a0bid")})
    @GetMapping(value={"getCourseItem"})
    public ResponseData<TrainingCourseItemVo> getCourseItemForMajor(Long traningCourseId, Long tuCoruseId) {
        this.tuCourseProviderService.checkOwner(null, tuCoruseId, ShiroUtil.getLoginUserId());
        return this.iTrainingProviderServiceForUser.getCourseItemDetailForMajor(traningCourseId, tuCoruseId);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u8bfe\u7a0b\u8be6\u60c5\uff08\u7cbe\u51c6\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tuCoruseId", value="\u5b66\u4e60\u8bb0\u5f55id")})
    @GetMapping(value={"getCourseItemForPrecise"})
    public ResponseData<TrainingCourseItemVo> getCourseItemForPrecise(Long tuCoruseId) {
        this.tuCourseProviderService.checkOwner(null, tuCoruseId, ShiroUtil.getLoginUserId());
        return this.iTrainingProviderServiceForUser.getCourseItemDetailForPrecise(tuCoruseId);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u6062\u590d\u5b66\u4e60\u8bb0\u5f55(\u5355\u4e2a\u8bfe\u7a0b)")
    @RequestLimit(second=20, maxCount=1, msg="\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42")
    @PostMapping(value={"restore"})
    public ResponseData restore(@RequestBody RestoreStuRecordParam param) {
        this.tuCourseProviderService.checkOwner(null, param.getTuCourseId(), ShiroUtil.getLoginUserId());
        this.tuCourseProviderService.restoreSingleness(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u6062\u590d\u5b66\u4e60\u8bb0\u5f55(\u6574\u4e2a\u57f9\u8bad)")
    @RequestLimit(second=20, maxCount=1, msg="\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42")
    @PostMapping(value={"restoreAll"})
    public ResponseData restoreAll(@RequestBody RestoreStuRecordParam param) {
        this.tuCourseProviderService.checkOwner(param.getEnrollDetailId(), null, ShiroUtil.getLoginUserId());
        this.tuCourseProviderService.restoreAll(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u57f9\u8bad\u8fdb\u5ea6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tuEnrollDetailId", value="\u57f9\u8bad\u8bfe\u7a0bid")})
    @GetMapping(value={"getTraningProgress"})
    public ResponseData<TraningProgressVo> getTraningProgress(Long tuEnrollDetailId) {
        TraningProgressVo vo = this.iTrainingProviderServiceForUser.getTraningProgress(tuEnrollDetailId);
        return ResponseData.success((Object)vo);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f-\u57f9\u8bad-\u8fdb\u5165\u8003\u8bd5\u5f39\u7a97")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tuCourseId", value="\u7528\u6237\u5b66\u4e60\u8bb0\u5f55Id")})
    @GetMapping(value={"getExamAlertInfo"})
    public ResponseData<ExamAlertInfoVo> getExamAlertInfo(Long tuCourseId) {
        ExamAlertInfoVo vo = this.iTrainingProviderServiceForUser.getExamAlertInfo(tuCourseId);
        return ResponseData.success((Object)vo);
    }

    @ApiOperation(value="\u67e5\u770b\u4e2a\u4eba\u4e2d\u5fc3-\u83b7\u53d6\u8003\u8bd5\u4e0d\u540c\u8fc7\u4e14\u5269\u4f59\u6b21\u6570\u4e3a\u96f6\u7684\u8bfe\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tid", value="\u57f9\u8badid"), @ApiImplicitParam(name="enrollDetailId", value="\u62a5\u540did")})
    @GetMapping(value={"getFlunkedCourse", "getFlunkedCourseForPrecise", "getFlunkedCourseForOrg"})
    public ResponseData<List<CourseItemCatalogueVo>> getFlunkedCourse(Long tid, Long enrollDetailId) {
        return ResponseData.success((Object)this.tuCourseProviderService.getFlunkedCourse(tid, enrollDetailId));
    }

    @ApiOperation(value="\u67e5\u770b\u4e2a\u4eba\u4e2d\u5fc3-test")
    @ApiImplicitParams(value={@ApiImplicitParam(name="enrollDetailId", value="\u57f9\u8badid")})
    @GetMapping(value={"test"})
    public ResponseData<String> syncTest(Long enrollDetailId) {
        this.tuCourseProviderService.syncEnrollInfo(enrollDetailId);
        return ResponseData.success();
    }
}

