/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.trainingCenter;

import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.enums.PersnoalEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonalEnrollParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollResultVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=29, author="\u5434\u5c0f\u5f3a")
@Api(tags={"\u4e2a\u4eba\u62a5\u540d"})
@RestController
@RequestMapping(value={"/personal"})
@Validated
public class SignUpController {
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private IUserProviderService userProviderService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/sign/individual", "/sign/major/individual", "/sign/precise/individual", "/sign/org/individual"})
    @RequestLimit(second=5, maxCount=1, msg="\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42")
    @ApiOperation(value="\u4e2a\u4eba\u901a\u8fc7\u70b9\u51fb\u57f9\u8bad\u62a5\u540d\u63d0\u4ea4 ")
    public ResponseData<String> personalSignUpForMajorByIndividual(@RequestBody PersonalEnrollParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainingId", "companyName"});
        if (!this.ifCanEnrollOpt(param.getTrainingId(), ShiroUtil.getLoginUserId())) {
            return ResponseData.fail((String)"\u62a5\u540d\u4fe1\u606f\u6821\u9a8c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        param.setUserId(ShiroUtil.getLoginUserId());
        param.setSource(PersnoalEnrollSourceEnum.PERSONAL.getValue());
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            UserVo user = this.userProviderService.getUserVo(principal.getUserId());
            PersonalUserVo userInfo = this.userProviderService.getPersonalUserInfo(principal.getUserId());
            if (user != null) {
                param.setEmail(user.getEmail());
                param.setPhone(user.getUsername());
            }
            if (userInfo != null) {
                param.setIdcard(userInfo.getIdcard());
                param.setName(userInfo.getName());
            }
        }
        RLock lock = this.redissonClient.getLock("crop_enroll_" + param.getTrainingId() + "_" + param.getCid());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.enrollProviderService.personalSignUpByIndividual(param);
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new RuntimeException("\u52a0\u8f7d\u7f13\u5b58\u4e2d\u8bf7\u7a0d\u7b49");
        }
        return ResponseData.success((String)"\u62a5\u540d\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/sign/individual/xh"})
    @RequestLimit(second=5, maxCount=1, msg="\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42")
    @ApiOperation(value="\u4e2a\u4eba\u901a\u8fc7\u70b9\u51fb\u57f9\u8bad\u62a5\u540d\u63d0\u4ea4(\u534f\u4f1a\u57f9\u8bad)")
    public ResponseData<EnrollResultVo> personalSignUpForMajorByIndividualXH(@RequestBody PersonalEnrollParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainingId", "companyName"});
        if (!this.ifCanEnrollOpt(param.getTrainingId(), ShiroUtil.getLoginUserId())) {
            return ResponseData.fail((String)"\u62a5\u540d\u4fe1\u606f\u6821\u9a8c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        param.setUserId(ShiroUtil.getLoginUserId());
        param.setSource(PersnoalEnrollSourceEnum.PERSONAL.getValue());
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            UserVo user = this.userProviderService.getUserVo(principal.getUserId());
            PersonalUserVo userInfo = this.userProviderService.getPersonalUserInfo(principal.getUserId());
            if (user != null) {
                param.setEmail(user.getEmail());
                param.setPhone(user.getUsername());
            }
            if (userInfo != null) {
                param.setIdcard(userInfo.getIdcard());
                param.setName(userInfo.getName());
            }
        }
        RLock lock = this.redissonClient.getLock("crop_enroll_" + param.getTrainingId() + "_" + param.getCid());
        boolean resLock = false;
        EnrollResultVo enrollResultVo = null;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                enrollResultVo = this.enrollProviderService.personalSignUpByIndividual(param);
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new RuntimeException("\u52a0\u8f7d\u7f13\u5b58\u4e2d\u8bf7\u7a0d\u7b49");
        }
        return ResponseData.success((String)"\u62a5\u540d\u6210\u529f\uff01", (Object)enrollResultVo);
    }

    private boolean ifCanEnrollOpt(Long tid, Long targetId) {
        String hashCache = this.redisUtil.get((Object)RedisKey.getAtomEnrollOpt((Long)tid, (Long)targetId));
        if (hashCache == null) {
            return true;
        }
        String code = hashCache;
        return code.equals("0");
    }

    @ApiOperation(value="\u57f9\u8bad\u62a5\u540d\u5f85\u652f\u4ed8\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/getSignUpOrderDetails"})
    public ResponseData<EnrollResultVo> getSignUpOrderDetails(IdParam param) {
        EnrollResultVo orderModel = this.enrollProviderService.getSignUpOrderDetails(param.getId());
        return ResponseData.success((Object)orderModel);
    }

    @Generated
    public SignUpController() {
    }
}

