/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.personalCenter;

import cn.hutool.core.util.DesensitizedUtil;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.AcUserInfoParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVoH5;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.AcUserInfoVo;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.wx.converter.H5Converter;
import cn.smarthse.radiationTraining.modules.wx.service.thrid.BaiduApiService;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5fae\u4fe1\u4e2a\u4eba-\u4e2a\u4eba\u4e2d\u5fc3"})
@ApiSupport(order=30, author="\u5434\u5c0f\u5f3a")
@RestController
@RequestMapping(value={"/personalCenter"})
@Validated
public class PersonalCenterController
extends ControllerSupport {
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;
    @Autowired
    private RedisUtil redisUtil;
    private final OssClientBean ossClientBean;
    private final BaiduApiService baiduApiService;
    private final H5Converter converter;

    @ApiOperation(value="\u5f53\u524d\u8d26\u53f7\u4fe1\u606f")
    @PostMapping(value={"/getPersonalInfo"})
    public ResponseData<PersonalUserVo> getPersonalInfo() {
        PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId());
        personalUserInfo.setIdcardTypeName(IdcardTypeEnum.getName((Integer)personalUserInfo.getIdcardType()));
        personalUserInfo.setIdcard(StringUtils.desensitizationCertificateNumber((String)personalUserInfo.getIdcard()));
        personalUserInfo.setName(StringUtils.desensitizationName((String)personalUserInfo.getName()));
        personalUserInfo.setEmail(DesensitizedUtil.email((String)personalUserInfo.getEmail()));
        return ResponseData.success((Object)personalUserInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u654f\u611f\u4fe1\u606f")
    @PostMapping(value={"/getAcInfo"})
    @Log(title="\u83b7\u53d6\u654f\u611f\u4fe1\u606f", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_view_user_sensitive_info)
    public ResponseData<AcUserInfoVo> getAcInfo(@RequestBody AcUserInfoParam param) {
        SysUser user = this.userProviderService.getFullUserInfoById(ShiroUtil.getLoginUserId());
        SysUserInfo sysUserInfo = user.getSysUserInfo();
        AcUserInfoVo vo = new AcUserInfoVo();
        if (param.getIncludeIdCard() == 1 && sysUserInfo != null) {
            vo.setIdCard(sysUserInfo.getIdcard());
        }
        if (param.getIncludeName() == 1 && user != null) {
            vo.setName(user.getName());
        }
        return ResponseData.success((Object)vo);
    }

    @ApiOperation(value="\u5f53\u524d\u8d26\u53f7\u4fe1\u606f-H5")
    @PostMapping(value={"/getPersonalInfoH5"})
    public ResponseData<PersonalUserVoH5> getPersonalInfoH5() {
        PersonalUserVoH5 personalUserVoH5 = this.converter.PersonalUserVo2PersonalUserVoH5(this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId()));
        personalUserVoH5.setIdcardTypeName(IdcardTypeEnum.getName((Integer)personalUserVoH5.getIdcardType()));
        personalUserVoH5.setIdcard(StringUtils.desensitizationCertificateNumber((String)personalUserVoH5.getIdcard()));
        personalUserVoH5.setName(StringUtils.desensitizationName((String)personalUserVoH5.getName()));
        personalUserVoH5.setEmail(DesensitizedUtil.email((String)personalUserVoH5.getEmail()));
        return ResponseData.success((Object)personalUserVoH5);
    }

    @PostMapping(value={"/editUser"})
    @ApiOperation(value="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599")
    @RequestLimit(second=1, maxCount=1)
    @Log(title="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> editUser(@RequestBody EditUserParam editUserParam) {
        try {
            editUserParam.setId(ShiroUtil.getLoginUserId());
            this.userProviderService.editPersonal(editUserParam);
            return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            this.logger.error("DuplicateKeyException:", (Throwable)e);
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"/editUser/xh"})
    @ApiOperation(value="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599(\u534f\u4f1a)")
    @RequestLimit(second=1, maxCount=1)
    @Log(title="\u7f16\u8f91\u4e2a\u4eba\u8d26\u53f7\u8d44\u6599(\u534f\u4f1a)", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> editXhUser(@RequestBody EditUserParam editUserParam) {
        try {
            editUserParam.setId(ShiroUtil.getLoginUserId());
            this.userProviderService.editXhPersonal(editUserParam);
            return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            this.logger.error("DuplicateKeyException:", (Throwable)e);
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528")
    @PostMapping(value={"forbiddenSelf"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenParam param) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(ShiroUtil.getLoginUserId());
        param.setIdList(null);
        param.setIdList(ids);
        param.setIsForbidden(Integer.valueOf(1));
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801-\u5bfc\u5165\u540e\u672a\u4fee\u6539\u5bc6\u7801\u7684")
    @ApiImplicitParams(value={@ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="uuid", value="\u516c\u94a5uuid", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPassword(@NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotEmpty(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") String uuid) {
        String privateKey = this.redisUtil.get((Object)uuid);
        password = RsaUtil.decrypt((String)password, (String)privateKey);
        this.userProviderService.modifyPassword(ShiroUtil.getLoginUserId(), password);
        return ResponseData.success();
    }

    @ApiOperation(value="\u901a\u8fc7\u65e7\u5bc6\u7801\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="uuid", value="\u516c\u94a5uuid", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String newPassword, @NotEmpty(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") String uuid) {
        String privateKey = this.redisUtil.get((Object)uuid);
        oldPassword = RsaUtil.decrypt((String)oldPassword, (String)privateKey);
        newPassword = RsaUtil.decrypt((String)newPassword, (String)privateKey);
        this.userProviderService.modifyPasswordByOldPwd(ShiroUtil.getLoginUserId(), oldPassword, newPassword);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4eba\u8138\u8ba4\u8bc1", notes="\u9650\u5236\u540c\u4e00\u4e2a\u8d26\u53f710\u6b21/12h\u4ee5\u5185")
    @RequestLimit(maxCount=1000, second=43200)
    @RequestMapping(value={"faceAuth"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<Boolean> faceAuth(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) {
        return ResponseData.success((String)"\u8ba4\u8bc1\u901a\u8fc7\uff01", (Object)true);
    }

    @Generated
    public PersonalCenterController(OssClientBean ossClientBean, BaiduApiService baiduApiService, H5Converter converter) {
        this.ossClientBean = ossClientBean;
        this.baiduApiService = baiduApiService;
        this.converter = converter;
    }
}

