/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.pay;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.AlipayProperties;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderService;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.wx.service.order.IPayService;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notify"})
public class PayNotifyController
extends ControllerSupport {
    private final AlipayProperties options;
    private final IPayService payService;
    @DubboReference
    private ISysOrderService sysOrderService;

    @Log(title="\u652f\u4ed8\u5b9d\u56de\u8c03", logModule=LogModuleTypeEnum.anon, type=LogTypeEnum.anon)
    @RequestMapping(value={"/alipay"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<String> notify_alipay(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, GeneralSecurityException, IOException {
        Map<String, String> params = this.payService.getPayResult_alipay(request);
        if (params == null) {
            return ResponseData.fail((String)"\u975e\u6cd5\u7684\u652f\u4ed8\u5b9d\u56de\u8c03\uff01");
        }
        Long out_trade_no = null;
        try {
            out_trade_no = Long.parseLong(params.get("out_trade_no"));
        }
        catch (NumberFormatException e1) {
            this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}-\u975e\u6cd5\u7684\u652f\u4ed8\u5b9d\u56de\u8c03", (Object)out_trade_no);
            return ResponseData.fail((String)"\u975e\u6cd5\u7684\u652f\u4ed8\u5b9d\u56de\u8c03");
        }
        this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}-\u5f00\u59cb", (Object)out_trade_no);
        SysOrder order = (SysOrder)this.sysOrderService.getById((Serializable)out_trade_no);
        if (!this.payService.rsaCheckV1(params) && !this.payService.check_from_AlipayTradeQuery(out_trade_no, order)) {
            return ResponseData.fail((String)"\u975e\u6cd5\u7684\u652f\u4ed8\u5b9d\u56de\u8c03\uff01");
        }
        String app_id = params.get("app_id");
        String trade_no = params.get("trade_no");
        String total_amount = params.get("total_amount");
        String trade_status = params.get("trade_status");
        String gmt_create = params.get("gmt_create");
        if ("TRADE_SUCCESS".equalsIgnoreCase(trade_status)) {
            try {
                if (!this.options.appId.equals(app_id)) {
                    this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}-\u975e\u6cd5\u7684\u652f\u4ed8\u5b9d\u56de\u8c03-appid:{}", (Object)out_trade_no, (Object)app_id);
                    return ResponseData.fail((String)"\u975e\u6cd5\u7684\u652f\u4ed8\u5b9d\u56de\u8c03\uff01");
                }
                if (order == null) {
                    this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}\u67e5\u65e0\u8be5\u8ba2\u5355\u4fe1\u606f", (Object)out_trade_no);
                    return ResponseData.fail((String)"\u67e5\u65e0\u8be5\u8ba2\u5355\u4fe1\u606f\uff01");
                }
                if (order.getPayState().equals(OrderPayStateEnum.PAY.getValue()) || order.getPayState().equals(OrderPayStateEnum.REFUND.getValue())) {
                    this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}\u8ba2\u5355\u5df2\u652f\u4ed8\u65e0\u9700\u518d\u6b21\u56de\u8c03", (Object)out_trade_no);
                    return ResponseData.success((String)"\u8ba2\u5355\u5df2\u652f\u4ed8\u65e0\u9700\u518d\u6b21\u56de\u8c03\uff01");
                }
                order.setPayMoney(new BigDecimal(total_amount));
                order.setPayState(OrderPayStateEnum.PAY.getValue());
                order.setPayDate((Date)DateUtil.parseDateTime((CharSequence)gmt_create));
                order.setOrderNo(trade_no);
                this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}-\u652f\u4ed8\u91d1\u989d\uff1a{}-\u652f\u4ed8\u65f6\u95f4\uff1a{}", new Object[]{out_trade_no, order.getPayMoney(), DateUtil.formatDateTime((Date)order.getPayDate())});
                this.payService.pay_callback(order);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("TRADE_CLOSED".equalsIgnoreCase(trade_status)) {
            this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}\uff0c\u4ea4\u6613\u5173\u95ed\uff01", (Object)out_trade_no);
        } else if ("TRADE_FINISHED".equalsIgnoreCase(trade_status)) {
            this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}\uff0c\u4ea4\u6613\u5df2\u5b8c\u6210\uff01", (Object)out_trade_no);
        } else {
            this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}-trade_status\uff1a{}-\u652f\u4ed8\u56de\u8c03\u5931\u8d25", (Object)out_trade_no, (Object)trade_status);
            return ResponseData.success((String)"\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff01");
        }
        this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03-out_trade_no\uff1a{}-\u56de\u8c03\u6210\u529f", (Object)out_trade_no);
        return ResponseData.success((String)"\u652f\u4ed8\u56de\u8c03\u6210\u529f");
    }

    @Generated
    public PayNotifyController(AlipayProperties options, IPayService payService) {
        this.options = options;
        this.payService = payService;
    }
}

