/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller.api;

import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.param.sys.CheckAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.QueryAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysAppVersionProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CheckAppVersionVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysAppVersionVo;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ApiSupport(order=200, author="\u9648\u4eae")
@Api(tags={"app\u7248\u672c\u8bb0\u5f55\u67e5\u770b"})
@Controller
@RequestMapping(value={"/api/app"})
public class AppVersionController
extends ControllerSupport {
    @DubboReference
    private ISysAppVersionProviderService sysAppVersionProviderService;

    @ApiOperation(value="app\u7248\u672c\u8bb0\u5f55\u67e5\u770b-\u5217\u8868")
    @GetMapping(value={"search"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u8bf7\u6c42")
    public ResponseData<LayuiGridData<SysAppVersionVo>> search(QueryAppVersionParam param) {
        return new ResponseData((Object)this.sysAppVersionProviderService.search(param));
    }

    @ApiOperation(value="app\u7248\u672c\u8bb0\u5f55\u67e5\u770b-\u6821\u9a8c\u5f53\u524dapp\u7248\u672c")
    @PostMapping(value={"check"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u8bf7\u6c42")
    public ResponseData<CheckAppVersionVo> checkUserAppVersion(@RequestBody CheckAppVersionParam param) {
        return ResponseData.success((Object)this.sysAppVersionProviderService.checkUserAppVersion(param));
    }

    @ApiOperation(value="app\u7248\u672c\u8bb0\u5f55\u67e5\u770b-\u67e5\u770b\u5f53\u524dapp\u7248\u672c")
    @GetMapping(value={"current"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u8bf7\u6c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="version", value="\u7248\u672c\u53f7"), @ApiImplicitParam(name="type", value="0\u5b89\u5353 1\u82f9\u679c")})
    public ResponseData<SysAppVersionVo> getCurrent(String version, Integer type) {
        return ResponseData.success((Object)this.sysAppVersionProviderService.getCurrVersion(version, type));
    }

    @ApiOperation(value="app\u7248\u672c\u8bb0\u5f55\u67e5\u770b-\u83b7\u53d6\u6700\u65b0\u7684\u3001\u9700\u8981\u5f3a\u5236\u66f4\u65b0\u7684\u7248\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="0\u5b89\u5353 1\u82f9\u679c")})
    @GetMapping(value={"newest/forced"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u8bf7\u6c42")
    public ResponseData<SysAppVersionVo> getNewestOfForcedUpdatingVersion(Integer type) {
        return new ResponseData((Object)this.sysAppVersionProviderService.getNewestOfForcedUpdatingVersion(type));
    }

    @ApiOperation(value="app\u7248\u672c\u8bb0\u5f55\u67e5\u770b-\u83b7\u53d6\u6700\u65b0\u7684\u7248\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="0\u5b89\u5353 1\u82f9\u679c")})
    @GetMapping(value={"newest"})
    @ResponseBody
    @RequestLimit(second=1, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u8bf7\u6c42")
    public ResponseData<SysAppVersionVo> getNewest(Integer type) {
        return new ResponseData((Object)this.sysAppVersionProviderService.getNewest(type));
    }
}

