/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.model.zlb.PersonInfo;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.modules.datacentre.provider.zlb.IZlbUserInfoProviderService;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.enums.SexEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.wx.service.zlb.IZlbClientServiceService;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u767b\u5f55"})
@RestController
@RequestMapping(value={"/login"})
@Validated
public class ZlbLoginController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbLoginController.class);
    private final LoginService loginService;
    private final IZlbClientServiceService zlbClientService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private IZlbUserInfoProviderService zlbUserInfoProviderService;

    @ApiOperation(value="\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55", notes="1.ticket\u83b7\u53d6token\uff1b2.\u7528token\u83b7\u53d6\u5f53\u524d\u6d59\u91cc\u529e\u7528\u6237\u4fe1\u606f\uff1b3.\u7528\u6d59\u91cc\u529euserId\u627e\u8d26\u53f7\u767b\u5f55\uff1b4.\u6ca1\u627e\u5230\u5219\u627e\u624b\u673a\u53f7\uff0c\u7528\u624b\u673a\u53f7\u6267\u884c\u767b\u5165\uff1b3.1.\u4e0d\u5b58\u5728\u8d26\u53f7\u5219\u5148\u6ce8\u518c\u518d\u6267\u884c\u6b65\u9aa43\u3002\uff08\u6682\u65f6\u4e0d\u8003\u8651\u6ca1\u6709\u624b\u673a\u53f7\u7684\u6d59\u91cc\u529e\u8d26\u53f7\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ticket", value="\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55\u7968\u636e", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="appId", value="appId(\u653f\u52a1\u670d\u52a1\u7f51\u5355\u70b9\u767b\u5f55\u624d\u9700\u8981\uff0c\u5e76\u4e14\u4e2a\u4eba\u548c\u6cd5\u4eba\u767b\u5f55\u662f\u4e0d\u4e00\u6837\u7684appId)", required=true, paramType="query", dataTypeClass=String.class)})
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u767b\u5165")
    @PostMapping(value={"/zlb"})
    public ResponseData<LoginData> loginByZlb(@NotEmpty String ticket, @NotEmpty String appId) {
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55: ticket\uff1a{}\uff0cappId\uff1a{}", (Object)ticket, (Object)appId);
        return this.login(this.zlbClientService.getZlbUserInfo(ticket, appId), null);
    }

    @ApiOperation(value="\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55v2", notes="1.\u524d\u7aef\u83b7\u53d6ticketId, 2.\u524d\u7aef\u83b7\u53d6\u6d59\u91cc\u529e\u7528\u6237\u4fe1\u606f\uff08getZlbUserInfo\u63a5\u53e3\uff09, 3.\u524d\u7aef\u8c03\u7528\u6b64\u63a5\u53e3\uff0c\u4f20\u5165zlbUserId\u548cuserType\u6267\u884c\u5355\u70b9\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="zlbUserId", value="\u6d59\u91cc\u529e\u7528\u6237id", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="userType", value="\u7528\u6237\u7c7b\u578b\uff0cPERSON\u4e2a\u4eba/LEGAL_PERSON\u6cd5\u4eba", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="areaIdStr", value="\u7528\u6237\u884c\u653f\u533a\u5212", required=false, paramType="query", dataTypeClass=String.class)})
    @BigLog(userRole=UserRoleEnum.MASSES_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module13)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u767b\u5165")
    @PostMapping(value={"/zlb/v2"})
    public ResponseData<LoginData> loginByZlbV2(@NotEmpty String zlbUserId, @NotEmpty String userType, String areaIdStr) {
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55: zlbUserId\uff1a{}\uff0cuserType: {}\uff0careaIdStr: {}", new Object[]{zlbUserId, userType, areaIdStr});
        return this.login(this.zlbUserInfoProviderService.getUserInfo(zlbUserId, userType), areaIdStr);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d59\u91cc\u529e\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ticket", value="\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5f55\u7968\u636e", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="appId", value="appId(\u653f\u52a1\u670d\u52a1\u7f51\u5355\u70b9\u767b\u5f55\u624d\u9700\u8981\uff0c\u5e76\u4e14\u4e2a\u4eba\u548c\u6cd5\u4eba\u767b\u5f55\u662f\u4e0d\u4e00\u6837\u7684appId)", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/getZlbUserInfo"})
    public ResponseData<Map<String, String>> getZlbUserInfo(@NotEmpty String ticket, @NotEmpty String appId) {
        ZlbUserInfo zlbUserInfo = this.zlbClientService.getZlbUserInfo(ticket, appId);
        if (zlbUserInfo == null) {
            log.error("\u6d59\u91cc\u529e\u4fe1\u606f\u83b7\u53d6\u5931\u8d25ticket:{},appid{}", (Object)StrUtil.sub((CharSequence)ticket, (int)0, (int)10), (Object)appId);
            return ResponseData.fail((String)"\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        this.zlbUserInfoProviderService.saveZlbUserInfo(zlbUserInfo);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userType", zlbUserInfo.getUserType());
        if ("PERSON".equalsIgnoreCase(zlbUserInfo.getUserType())) {
            result.put("nickName", zlbUserInfo.getPersonInfo().getUserName());
            result.put("zlbUserId", zlbUserInfo.getPersonInfo().getUserId());
        } else {
            result.put("nickName", zlbUserInfo.getLegalPersonInfo().getName());
            result.put("zlbUserId", zlbUserInfo.getLegalPersonInfo().getCorpId());
        }
        return ResponseData.success(result);
    }

    private ResponseData<LoginData> login(ZlbUserInfo zlbUserInfo, String areaIdStr) {
        if (zlbUserInfo == null) {
            return ResponseData.fail((String)"\u767b\u5165\u5931\u8d25\uff01");
        }
        if (!"PERSON".equalsIgnoreCase(zlbUserInfo.getUserType())) {
            return ResponseData.fail((String)"\u6cd5\u4eba\u7528\u6237\u65e0\u6743\u9650\uff01");
        }
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55 \u767b\u5f55\u8fc7\u7a0b: start {}", (Object)zlbUserInfo.getUserId());
        PersonInfo personInfo = zlbUserInfo.getPersonInfo();
        SysUser exists = this.userProviderService.getUserByZlbUserId(zlbUserInfo.getUserId());
        if (exists == null && (exists = this.userProviderService.getOneByIdCard(personInfo.getIdNo())) == null && (exists = this.userProviderService.getUserByUsername(personInfo.getPhone(), SysUserTypeEnum.USER.getValue())) == null) {
            exists = this.userProviderService.getUserByPhone(personInfo.getPhone());
        }
        Long areaId = null;
        if (StringUtils.isNotBlank((CharSequence)areaIdStr)) {
            try {
                Long.parseLong(areaIdStr);
                String paddedAreaIdStr = String.format("%-12d", Long.parseLong(areaIdStr)).replace(' ', '0');
                areaId = Long.parseLong(paddedAreaIdStr);
            }
            catch (Exception paddedAreaIdStr) {
                // empty catch block
            }
        }
        if (exists == null) {
            RegisterUserParam userParam = new RegisterUserParam();
            if (StringUtils.isBlank((CharSequence)personInfo.getPhone())) {
                String idNo_suffix;
                String username_prefix = PinyinUtil.getFirstLetter((String)personInfo.getUserName(), (String)"");
                String string = idNo_suffix = personInfo.getIdNo() != null && personInfo.getIdNo().length() >= 6 ? personInfo.getIdNo().substring(personInfo.getIdNo().length() - 6) : "";
                if (StringUtils.isBlank((CharSequence)(username_prefix + idNo_suffix))) {
                    userParam.setUsername("zlb" + System.currentTimeMillis());
                } else {
                    long count = this.userProviderService.getSameUsernameCount(username_prefix + idNo_suffix);
                    userParam.setUsername(username_prefix + idNo_suffix + (++count >= 10L ? Long.valueOf(count) : "0" + count));
                }
            } else {
                userParam.setUsername(personInfo.getPhone());
            }
            userParam.setName(personInfo.getUserName());
            userParam.setPassword("Zyj@2022");
            userParam.setIdcard(personInfo.getIdNo());
            userParam.setIdcardType(IdcardTypeEnum.getValueByCode((String)personInfo.getIdType()));
            userParam.setSex(SexEnum.getValueByCode((String)personInfo.getGender()));
            userParam.setPhone(personInfo.getPhone());
            userParam.setZlbUserId(personInfo.getUserId());
            userParam.setAreaId(areaId);
            exists = this.userProviderService.personalUserRegister(userParam);
        } else {
            this.userProviderService.updateIdcard(exists.getId(), personInfo.getUserName(), personInfo.getIdNo(), IdcardTypeEnum.getValueByCode((String)personInfo.getIdType()), areaId);
        }
        LoginData result = this.loginService.loginByUsername(exists.getUsername(), zlbUserInfo.getUserId());
        result.setNickName(personInfo.getUserName());
        result.setZlbUserId(personInfo.getUserId());
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55 \u767b\u5f55\u8fc7\u7a0b: end {}", (Object)zlbUserInfo.getUserId());
        return ResponseData.success((Object)result);
    }

    @Generated
    public ZlbLoginController(LoginService loginService, IZlbClientServiceService zlbClientService) {
        this.loginService = loginService;
        this.zlbClientService = zlbClientService;
    }
}

