/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestIpLimit;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.user.CheckPhoneParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.CheckUsernameParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterXhUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PhoneParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6ce8\u518c"})
@RestController
@RequestMapping(value={"/register"})
@Validated
public class UserRegisterController
extends ControllerSupport {
    private final LoginService loginService;
    @Autowired
    private RedisUtil redisUtil;
    @DubboReference(registry={"local_nacos"})
    private IUserProviderService userProviderService;

    @PostMapping(value={"/user/p"})
    @ApiOperation(value="\u4e2a\u4eba\u7528\u6237\u6ce8\u518c(\u624b\u673a\u53f7)")
    @Log(title="\u4e2a\u4eba\u7528\u6237\u6ce8\u518c(\u624b\u673a\u53f7)", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt_edit)
    @RequestLimit(second=60, maxCount=1, msg="\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c\uff01")
    public ResponseData<LoginData> personalUserRegister3(@RequestBody RegisterXhUserParam userParam) {
        FieldCheckUtils.checkEmptyFields((Object)userParam, (String[])new String[]{"password", "phone", "vcode", "uuid"});
        this.logger.info("\u534f\u4f1a\u4e2a\u4eba\u7528\u6237\u6ce8\u518c: {}", (Object)DesensitizedUtil.mobilePhone((String)userParam.getPhone()));
        userParam.setPhone(StringUtils.trim((String)userParam.getPhone()));
        userParam.setUsername(StringUtils.trim((String)userParam.getPhone()));
        userParam.setVcode(userParam.getVcode().toUpperCase());
        if (!this.loginService.checkPhoneRegisterCode(userParam.getPhone(), userParam.getVcode())) {
            return ResponseData.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        try {
            userParam.setUsername("xh" + System.currentTimeMillis());
            String privateKey = this.redisUtil.get((Object)userParam.getUuid());
            String password = RsaUtil.decrypt((String)userParam.getPassword(), (String)privateKey);
            userParam.setPassword(password);
            this.userProviderService.personalUserRegisterForXh(userParam);
            this.loginService.cleanCache(RedisKey.getPhoneRegisterCodeKey((String)userParam.getPhone()));
            return ResponseData.success((String)"\u6ce8\u518c\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            this.logger.error("DuplicateKeyException\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u6ce8\u518c\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"/checkUsername"})
    @ApiOperation(value="\u6821\u9a8c\u8d26\u53f7\u662f\u5426\u88ab\u6ce8\u518c")
    public ResponseData<Boolean> checkPhone(@RequestBody CheckUsernameParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"phone"});
        SysUser user = this.userProviderService.getUserByPhone(param.getPhone());
        if (user == null) {
            return ResponseData.success((String)"\u8d26\u53f7\u53ef\u7528", (Object)true);
        }
        if (user.getHasRegisteredXh() == 0) {
            return ResponseData.success((String)"\u8d26\u53f7\u53ef\u7528", (Object)true);
        }
        return ResponseData.success((String)"\u8d26\u53f7\u4e0d\u53ef\u7528", (Object)false);
    }

    @ApiOperation(value="\u6821\u9a8c\u624b\u673a\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/checkPhoneCode"})
    @RequestLimit(maxCount=2, second=60)
    public ResponseData<Boolean> checkPhoneCode(@RequestBody CheckPhoneParam param) {
        if (StrUtil.isBlank((CharSequence)param.getPhone()) || StrUtil.isBlank((CharSequence)param.getCode()) || param.getType() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        param.setCode(param.getCode().toUpperCase());
        boolean flag = false;
        if (param.getType() == 1) {
            flag = this.loginService.checkPhoneRegisterCode(param.getPhone(), param.getCode());
        }
        return ResponseData.success((String)(flag ? "\u6821\u9a8c\u6210\u529f" : "\u6821\u9a8c\u5931\u8d25"), (Object)flag);
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801(\u6ce8\u518c)")
    @Log(title="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801(\u6ce8\u518c)", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt)
    @RequestIpLimit(maxCount=1, second=60)
    @PostMapping(value={"/sendMobileCode/Register"})
    public ResponseData<Boolean> sendMobileRegisterCode(@RequestBody PhoneParam mobile) {
        return ResponseData.success((Object)this.loginService.sendPhoneCodeForRegister(mobile.getPhone()));
    }

    @Generated
    public UserRegisterController(LoginService loginService) {
        this.loginService = loginService;
    }
}

