/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.ModifyPasswordOnlineParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bc6\u7801"})
@RestController
@RequestMapping(value={"/pw"})
@Validated
public class PasswordOnlineController
extends ControllerSupport {
    private final LoginService loginService;
    private final StringRedisTemplate stringRedisTemplate;
    @DubboReference
    private IUserProviderService userProviderService;

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801-\u767b\u5f55")
    @Log(title="\u4fee\u6539\u5bc6\u7801-\u767b\u5f55", logModule=LogModuleTypeEnum.user_info_wx, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPasswordInOnline(@RequestBody ModifyPasswordOnlineParam param) {
        if (ShiroUtil.getLoginUserId() == null) {
            throw new ServiceException("\u4fe1\u606f\u9519\u8bef\uff01");
        }
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{param.getUuid(), param.getNewPassword(), param.getOldPassword()})) {
            throw new ServiceException("\u4fe1\u606f\u9519\u8bef\uff01");
        }
        param.setUserId(ShiroUtil.getLoginUserId());
        String privateKey = (String)this.stringRedisTemplate.opsForValue().get((Object)param.getUuid());
        String newPassword = RsaUtil.decrypt((String)param.getNewPassword(), (String)privateKey);
        String oldPassword = RsaUtil.decrypt((String)param.getOldPassword(), (String)privateKey);
        param.setMwNewPassword(newPassword);
        param.setMwOldPassword(oldPassword);
        this.loginService.modifyPasswordOnline(param);
        return ResponseData.success();
    }

    @Generated
    public PasswordOnlineController(LoginService loginService, StringRedisTemplate stringRedisTemplate) {
        this.loginService = loginService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

