/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.controller;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.RsaUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PasswordLoginParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.PublicKeyParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.smarthse.radiationTraining.exception.ServiceException;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u767b\u5f55"})
@RestController
@RequestMapping(value={"/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final StringRedisTemplate stringRedisTemplate;
    @DubboReference
    private IUserProviderService userProviderService;
    private static final int md5PasswordLength = 33;

    @ApiOperation(value="token\u5237\u65b0")
    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @ApiOperation(value="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    @ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=true, paramType="query", dataTypeClass=String.class)
    @RequestLimit(second=60, maxCount=1, msg="\u8bf71\u5206\u949f\u540e\u91cd\u8bd5")
    @PostMapping(value={"/sendEmailCode"})
    public ResponseData<Boolean> sendEmailCode(@ApiParam(value="\u90ae\u7bb1") String email) {
        SysUser exists = this.userProviderService.getOneByEmail(email);
        if (exists == null) {
            return ResponseData.fail((String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\uff01");
        }
        return ResponseData.success((Object)this.loginService.sendEmailCodeForResetPwd(email, exists.getUsername()));
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @ApiImplicitParam(name="key", value="key\u524d\u7aef\u81ea\u884c\u751f\u6210", required=true, paramType="query", dataTypeClass=String.class)
    @PostMapping(value={"/sendVcode"})
    public ResponseData<String> sendVcode(@ApiParam(value="key") @NotEmpty(message="key\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="key\u4e0d\u80fd\u4e3a\u7a7a") String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVcode(key));
    }

    @ApiOperation(value="\u6821\u9a8c\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="code", value="\u9a8c\u8bc1\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/checkEmailCode"})
    public ResponseData<Boolean> checkEmailCode(String email, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String code) {
        return ResponseData.success((Object)this.loginService.checkEmailCode(email, code));
    }

    @ApiOperation(value="\u83b7\u53d6\u516c\u94a5")
    @PostMapping(value={"/getPublicKey"})
    public ResponseData<String> getPublicKey(@RequestBody PublicKeyParam param) {
        if (param.getUuid() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map stringStringMap = RsaUtil.genKeyPair();
        this.logger.debug("publicKeyMap: {}", (Object)stringStringMap);
        String privateKey = (String)stringStringMap.get("privateKey");
        this.stringRedisTemplate.opsForValue().set((Object)param.getUuid(), (Object)privateKey, 30L, TimeUnit.MINUTES);
        return ResponseData.success((String)"\u6210\u529f", stringStringMap.get("publicKey"));
    }

    @ApiOperation(value="\u5bc6\u7801\u767b\u5f55")
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="web\u767b\u5165")
    @RequestLimit(maxCount=2, second=60)
    @PostMapping(value={"/web/password"})
    public ResponseData<LoginData> loginByPasswordForWeb(@RequestBody PasswordLoginParam param) {
        String username = param.getUsername();
        String password = param.getPassword();
        String key = param.getKey();
        String code = param.getCode();
        String uuid = param.getUuid();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{username, password, uuid, key, code})) {
            throw new ServiceException("\u767b\u5f55\u5931\u8d25\uff01");
        }
        this.logger.info("\u5bc6\u7801\u767b\u5f55: {}", (Object)username);
        if (!this.loginService.checkVcode(key, code, true)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        String privateKey = (String)this.stringRedisTemplate.opsForValue().get((Object)uuid);
        if (privateKey == null) {
            ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff01");
        }
        password = RsaUtil.decrypt((String)password, (String)privateKey);
        return ResponseData.success((Object)this.loginService.loginByPassword(username, password));
    }

    @Generated
    public LoginController(LoginService loginService, StringRedisTemplate stringRedisTemplate) {
        this.loginService = loginService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

