/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service;

import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.User;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        return (ShiroPrincipal)ShiroUtil.getSubject().getPrincipal();
    }

    public static User getUser() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            return principal.getUser();
        }
        return null;
    }

    public static Long getLoginUserId() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getUserId() : null;
    }

    public static String getLoginUsername() {
        User user = ShiroUtil.getUser();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginUserNickname() {
        User user = ShiroUtil.getUser();
        return user != null ? user.getName() : null;
    }

    public static Long getLoginAreaId() {
        User user = ShiroUtil.getUser();
        return user != null ? user.getAreaId() : null;
    }

    public static String getLoginUserPhone() {
        User user = ShiroUtil.getUser();
        return user != null ? user.getPhone() : null;
    }

    public static Long getCurCid() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getCid() : null;
    }

    public static String getCurCompanyName() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getCompanyName() : null;
    }

    public static Integer getUserType() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getUserType() : null;
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getShiroPrincipal().getRoleSet().contains(roleCode);
    }

    public static boolean isSuperAdmin() {
        return ShiroUtil.getShiroPrincipal().getRoleSet().contains("superadmin");
    }

    public static void flushCid(Long cid, String companyName) {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            principal.setCid(cid);
            principal.setCompanyName(companyName);
            SimplePrincipalCollection newPrincipalCollection = new SimplePrincipalCollection((Object)principal, principal.getUser().getUsername());
            subject.runAs((PrincipalCollection)newPrincipalCollection);
        }
    }

    public static Integer getUserLoginFrom() {
        return ShiroUtil.getShiroPrincipal().getLoginFrom();
    }
}

