/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.security.realms;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.User;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PasswordRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordRealm.class);
    @Autowired(required=false)
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        log.debug("{} - password auth start...", (Object)token.getUsername());
        SysUser user = this.tokenService.getUserByToken(token.getUsername(), SysUserTypeEnum.USER.getValue());
        if (user == null) {
            throw new UnknownAccountException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        if (user.getHasRegisteredXh() == 0) {
            throw new UnknownAccountException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        if (user.getIsForbidden() == Constant.YES) {
            throw new DisabledAccountException();
        }
        String credentials = user.getPassword();
        String realmName = super.getName();
        ByteSource credentialsSalt = ByteSource.Util.bytes((String)user.getSalt());
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(new User(user)), (Object)credentials, credentialsSalt, realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

