/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor;

import cn.hutool.extra.servlet.ServletUtil;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;

public class RequestLimitInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLimitInterceptor.class);
    private static final SerializeConfig CONFIG = new SerializeConfig();
    @Resource
    private RedisTemplate<String, Integer> redisTemplate;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, Object handler) {
        if (handler.getClass().isAssignableFrom(HandlerMethod.class)) {
            RequestLimit requestLimit;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RequestLimit methodAnnotation = method.getAnnotation(RequestLimit.class);
            RequestLimit classAnnotation = method.getDeclaringClass().getAnnotation(RequestLimit.class);
            RequestLimit requestLimit2 = requestLimit = methodAnnotation != null ? methodAnnotation : classAnnotation;
            if (requestLimit != null && this.isLimit(request, requestLimit)) {
                ServletUtils.renderString((HttpServletResponse)response, (String)JSON.toJSONString((Object)new ResponseData(ResponseStateEnum.fail, requestLimit.msg()), (SerializeConfig)CONFIG, (SerializerFeature[])new SerializerFeature[0]));
                return false;
            }
        }
        return true;
    }

    public boolean isLimit(HttpServletRequest request, RequestLimit requestLimit) {
        String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        String param = "";
        if (!(request instanceof StandardMultipartHttpServletRequest)) {
            param = ServletUtils.getRequestParam((HttpServletRequest)request);
        }
        String servletPath = request.getServletPath();
        String limitKey = RedisKey.getRequestLimitKey((String)ip, (String)servletPath, (String)param);
        Integer count = (Integer)this.redisTemplate.opsForValue().get((Object)limitKey);
        Long expire = this.redisTemplate.getExpire((Object)limitKey, TimeUnit.SECONDS);
        if (count == null) {
            this.redisTemplate.opsForValue().set((Object)limitKey, (Object)1, (long)requestLimit.second(), TimeUnit.SECONDS);
        } else {
            if (count >= requestLimit.maxCount()) {
                return true;
            }
            this.redisTemplate.opsForValue().set((Object)limitKey, (Object)(count + 1), expire == null ? (long)requestLimit.second() : expire, TimeUnit.SECONDS);
        }
        return false;
    }

    static {
        CONFIG.configEnumAsJavaBean(new Class[]{ResponseStateEnum.class});
    }
}

