/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor;

import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestIpLimit;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class RequestIpLimitInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestIpLimitInterceptor.class);
    private static final SerializeConfig CONFIG = new SerializeConfig();
    @Resource
    private RedisTemplate<String, Integer> redisTemplate;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, Object handler) {
        if (handler.getClass().isAssignableFrom(HandlerMethod.class)) {
            RequestIpLimit RequestIpLimit2;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RequestIpLimit methodAnnotation = method.getAnnotation(RequestIpLimit.class);
            RequestIpLimit classAnnotation = method.getDeclaringClass().getAnnotation(RequestIpLimit.class);
            RequestIpLimit requestIpLimit = RequestIpLimit2 = methodAnnotation != null ? methodAnnotation : classAnnotation;
            if (RequestIpLimit2 != null && this.isLimit(request, RequestIpLimit2)) {
                ServletUtils.renderString((HttpServletResponse)response, (String)JSON.toJSONString((Object)new ResponseData(ResponseStateEnum.fail, "\u8bf7\u6c42\u9650\u5236\u3002"), (SerializeConfig)CONFIG, (SerializerFeature[])new SerializerFeature[0]));
                return false;
            }
        }
        return true;
    }

    public boolean isLimit(HttpServletRequest request, RequestIpLimit RequestIpLimit2) {
        String ip = request.getRemoteAddr();
        String limitKey = RedisKey.getRequestIpLimitKey((String)ip);
        Integer count = (Integer)this.redisTemplate.opsForValue().get((Object)limitKey);
        if (count == null) {
            this.redisTemplate.opsForValue().set((Object)limitKey, (Object)1, (long)RequestIpLimit2.second(), TimeUnit.SECONDS);
        } else {
            if (count >= RequestIpLimit2.maxCount()) {
                return true;
            }
            this.redisTemplate.opsForValue().set((Object)limitKey, (Object)(count + 1), (long)RequestIpLimit2.second(), TimeUnit.SECONDS);
        }
        return false;
    }

    static {
        CONFIG.configEnumAsJavaBean(new Class[]{ResponseStateEnum.class});
    }
}

