/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogConstans;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogResourceEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.SysLog;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ILogProviderService;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class LogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    @DubboReference
    private ILogProviderService logProviderService;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (handler instanceof ResourceHttpRequestHandler) {
            return;
        }
        try {
            HandlerMethod methodHandler;
            Log log;
            if (handler instanceof HandlerMethod && (log = (methodHandler = (HandlerMethod)handler).getMethod().getAnnotation(Log.class)) != null) {
                ShiroPrincipal principal = (ShiroPrincipal)SecurityUtils.getSubject().getPrincipal();
                if (principal == null) {
                    return;
                }
                SysLog syslog = new SysLog();
                syslog.setUserId(principal.getUser().getId());
                syslog.setUsername(StringUtils.isBlank((CharSequence)principal.getUser().getUsername()) ? principal.getUser().getEmail() : principal.getUser().getUsername());
                syslog.setFullname(principal.getUser().getName());
                syslog.setTitle(log.title());
                syslog.setResource(LogResourceEnum.WX.getValue());
                syslog.setType(log.type().value);
                syslog.setModuleType(log.module().equals((Object)LogConstans.anon) ? log.logModule().moduleType : log.module().moduleType);
                this.setParams(request, syslog);
                syslog.setRequestMethod(request.getMethod());
                syslog.setRemoteIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
                syslog.setRequestUri(request.getRequestURI());
                syslog.setUserAgent(request.getHeader("user-agent"));
                syslog.setCreateBy(principal.getUser().getId());
                syslog.setUpdateBy(principal.getUser().getId());
                this.threadPoolTaskExecutor.execute(() -> this.logProviderService.addLog(syslog));
            }
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
    }

    private void setParams(HttpServletRequest request, SysLog syslog) {
        if (syslog.getType().equals(LogTypeEnum.type_login.value) || request instanceof StandardMultipartHttpServletRequest) {
            return;
        }
        Map parameterMap = request.getParameterMap();
        syslog.setParams(CollectionUtil.isNotEmpty((Map)parameterMap) ? JSONUtil.toJsonStr((Object)parameterMap) : ServletUtil.getBody((ServletRequest)request));
    }
}

