/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap;

import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.radiationTraining.core.framework.bootstrap.DateBeanSerializerModifier;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.filter.MultiReadHttpServletRequestFilter;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor.BigDataLogInterceptor;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor.LogInterceptor;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor.RequestIpLimitInterceptor;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor.RequestLimitInterceptor;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.interceptor.WebLogMdcHandlerInterceptor;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.Filter;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    @Autowired
    private SysProperties sysProperties;
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowCredentials(false).allowedMethods(new String[]{"*"}).maxAge(3600L);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.requestLimitInterceptor()).excludePathPatterns(new String[]{"/webjars/**", "/swagger-ui.html", "/swagger-resources/**", "/v2/**", "/images/**"}).addPathPatterns(new String[]{"/**"}).order(0x7FFFFFFE);
        registry.addInterceptor((HandlerInterceptor)this.requestIpLimitInterceptor()).excludePathPatterns(new String[]{"/webjars/**", "/swagger-ui.html", "/swagger-resources/**", "/v2/**", "/images/**"}).addPathPatterns(new String[]{"/**"}).order(0x7FFFFFFE);
        registry.addInterceptor((HandlerInterceptor)this.LogInterceptor()).excludePathPatterns(new String[]{"/webjars/**", "/swagger-ui.html", "/swagger-resources/**", "/v2/**", "/images/**"}).addPathPatterns(new String[]{"/**"}).order(0x7FFFFFFE);
        registry.addInterceptor((HandlerInterceptor)this.WebLogMdcHandlerInterceptor()).excludePathPatterns(new String[]{"/webjars/**", "/swagger-ui.html", "/swagger-resources/**", "/v2/**", "/images/**"}).addPathPatterns(new String[]{"/**"}).order(0x7FFFFFFE);
        registry.addInterceptor((HandlerInterceptor)new BigDataLogInterceptor(this.sysProperties, this.bigDataLogProviderService)).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public RequestLimitInterceptor requestLimitInterceptor() {
        return new RequestLimitInterceptor();
    }

    @Bean
    public RequestIpLimitInterceptor requestIpLimitInterceptor() {
        return new RequestIpLimitInterceptor();
    }

    @Bean
    public LogInterceptor LogInterceptor() {
        return new LogInterceptor();
    }

    @Bean
    public WebLogMdcHandlerInterceptor WebLogMdcHandlerInterceptor() {
        return new WebLogMdcHandlerInterceptor();
    }

    @Bean
    public FilterRegistrationBean filterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new MultiReadHttpServletRequestFilter());
        ArrayList<String> urlList = new ArrayList<String>();
        urlList.add("/*");
        registration.setUrlPatterns(urlList);
        registration.setName("UrlFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.jackson2Converter());
        super.configureMessageConverters(converters);
    }

    @Bean
    public MappingJackson2HttpMessageConverter jackson2Converter() {
        MappingJackson2HttpMessageConverter jackson2Converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        objectMapper.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        jackson2Converter.setObjectMapper(objectMapper);
        objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new DateBeanSerializerModifier()));
        return jackson2Converter;
    }
}

