/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wx.bootstrap;

import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.AlipayProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.BaiduApiFaceProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.TaskExecutorProperties;
import cn.smarthse.radiationTraining.core.framework.utils.SpringContextHolder;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.dto.XssProperties;
import com.baidu.aip.face.AipFace;
import lombok.Generated;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={OssClientProperties.class, BaiduApiFaceProperties.class, TaskExecutorProperties.class, SysProperties.class, AlipayProperties.class, XssProperties.class})
@ComponentScan(basePackages={"cn.smarthse.radiationTraining.modules.wx", "cn.smarthse.radiationTraining.modules.wqxx", "cn.smarthse.radiationTraining.core.framework", "springfox.documentation.schema"})
public class ContentConfiguration
extends BaseConfiguration {
    private final OssClientProperties ossClientProperties;
    private final BaiduApiFaceProperties baduApiFaceProperties;
    private final TaskExecutorProperties taskExecutorProperties;

    @Bean(name={"ossclient"})
    public OssClientBean getOssClientBean() {
        this.logger.info("\u914d\u7f6eOssClientBean {}\uff0clocal\uff1a{}", (Object)this.ossClientProperties.getOss_bucketname(), (Object)this.ossClientProperties.getOss_local());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getOss_local());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean(name={"aipFace"})
    public AipFace getAipFace() {
        this.logger.info("\u914d\u7f6eAipFace");
        return new AipFace(this.baduApiFaceProperties.getAppId(), this.baduApiFaceProperties.getAipKey(), this.baduApiFaceProperties.getAipToken());
    }

    @Bean
    public ThreadPoolTaskExecutor taskExecutor() {
        this.logger.info("\u914d\u7f6eThreadPoolTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(this.taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> this.logger.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u7ebf\u7a0b\u62d2\u7edd\u6267\u884c\uff1a{}", (Object)r.toString()));
        executor.initialize();
        return executor;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Generated
    public ContentConfiguration(OssClientProperties ossClientProperties, BaiduApiFaceProperties baduApiFaceProperties, TaskExecutorProperties taskExecutorProperties) {
        this.ossClientProperties = ossClientProperties;
        this.baduApiFaceProperties = baduApiFaceProperties;
        this.taskExecutorProperties = taskExecutorProperties;
    }
}

