/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.controller.personalCenter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.unit.DataSize;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.enums.SystemDeploymentSourceEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.uploader.FileResourceEnum;
import cn.smarthse.radiationTraining.core.framework.uploader.FileUploadSimple;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFileParameter;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVoH5;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxCompanyListVo;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.wx.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.wx.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.wx.converter.H5Converter;
import cn.smarthse.radiationTraining.modules.wx.service.thrid.BaiduApiService;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u536b\u4f01\u5b66\u4e60-\u4e2a\u4eba\u4e2d\u5fc3"})
@ApiSupport(order=30, author="\u891a\u6d77\u6d0b")
@RestController
@RequestMapping(value={"/wqxx/personalCenter"})
@Validated
public class WqxxPersonalCenterController
extends ControllerSupport {
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ITuEnrollProviderService tuEnrollProviderService;
    @Autowired
    private RedisUtil redisUtil;
    private final OssClientBean ossClientBean;
    private final BaiduApiService baiduApiService;
    private final H5Converter converter;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ISysCompanyStaffProviderService companyStaffProviderService;

    @ApiOperation(value="\u5f53\u524d\u8d26\u53f7\u4fe1\u606f-H5")
    @PostMapping(value={"/getPersonalInfoH5"})
    public ResponseData<PersonalUserVoH5> getPersonalInfoH5() {
        PersonalUserVoH5 personalUserVoH5 = this.converter.PersonalUserVo2PersonalUserVoH5(this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId()));
        personalUserVoH5.setIdcardTypeName(IdcardTypeEnum.getName((Integer)personalUserVoH5.getIdcardType()));
        personalUserVoH5.setIdcard(StringUtils.desensitizationCertificateNumber((String)personalUserVoH5.getIdcard()));
        personalUserVoH5.setName(StringUtils.desensitizationName((String)personalUserVoH5.getName()));
        personalUserVoH5.setEmail(DesensitizedUtil.email((String)personalUserVoH5.getEmail()));
        return ResponseData.success((Object)this.converter.PersonalUserVo2PersonalUserVoH5(this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId())));
    }

    @ApiOperation(value="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528")
    @PostMapping(value={"forbiddenSelf"})
    @Log(title="\u4e2a\u4eba\u8d26\u53f7-\u7981\u7528\u3001\u542f\u7528", logModule=LogModuleTypeEnum.sys, type=LogTypeEnum.type_opt_edit)
    public ResponseData<String> forbiddenUser(@RequestBody ForbiddenParam param) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(ShiroUtil.getLoginUserId());
        param.setIdList(null);
        param.setIdList(ids);
        param.setIsForbidden(Integer.valueOf(1));
        this.userProviderService.forbiddenUser(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4eba\u8138\u8ba4\u8bc1", notes="\u9650\u5236\u540c\u4e00\u4e2a\u8d26\u53f710\u6b21/12h\u4ee5\u5185")
    @RequestLimit(maxCount=1000, second=43200)
    @RequestMapping(value={"faceAuth"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<Boolean> faceAuth(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) {
        Long userId = ShiroUtil.getLoginUserId();
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.FACE_AUTH.getPath();
        String realPath = this.ossClientBean.getLocal() + uploadDir;
        UploadFileParameter up = new UploadFileParameter();
        up.setRequest(request);
        up.setUploadDir(uploadDir);
        up.setRealPath(realPath);
        up.setFileResource(Integer.valueOf(FileResourceEnum.radiation_training.getValue()));
        FileUploadSimple.upload_pluploader((UploadFileParameter)up);
        String image1 = "";
        String image2 = "";
        String photoUrl = this.userProviderService.getPhotoUrl(userId);
        if (StringUtils.isBlank((CharSequence)photoUrl)) {
            return ResponseData.success((String)"\u8bc1\u4ef6\u7167\u4e0d\u5b58\u5728\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
        }
        try {
            int image2Length;
            long twoMb = DataSize.ofMegabytes((long)2L).toBytes();
            long tarMb = twoMb * 95L / 100L;
            image1 = Base64Util.encode((byte[])Util.readFileByBytes((String)(up.getRealPath() + File.separator + up.getFileName())));
            image2 = Base64Util.encode((byte[])HttpUtil.downloadBytes((String)photoUrl));
            long image1Length = up.getFile().length();
            if (image1Length > twoMb) {
                BigDecimal num1 = new BigDecimal(tarMb);
                BigDecimal num2 = new BigDecimal(image1Length);
                Image scaleImage1 = ImgUtil.scale((Image)ImgUtil.toImage((String)image1), (float)num1.divide(num2, 2, RoundingMode.DOWN).floatValue());
                image1 = ImgUtil.toBase64((Image)scaleImage1, (String)"jpg");
            }
            if ((long)(image2Length = HttpUtil.downloadBytes((String)photoUrl).length) > twoMb) {
                BigDecimal num1 = new BigDecimal(tarMb);
                BigDecimal num2 = new BigDecimal(image2Length);
                Image scaleImage2 = ImgUtil.scale((Image)ImgUtil.toImage((String)image2), (float)num1.divide(num2, 2, RoundingMode.DOWN).floatValue());
                image2 = ImgUtil.toBase64((Image)scaleImage2, (String)"jpg");
            }
        }
        catch (IOException e) {
            this.logger.error("IOException: ", (Throwable)e);
        }
        if (this.baiduApiService.doFaceMatch(image1, image2)) {
            return ResponseData.success((String)"\u8ba4\u8bc1\u901a\u8fc7\uff01", (Object)true);
        }
        return ResponseData.success((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff01", (Object)false);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4f4d\u5217\u8868-\u7528\u4e8e\u767b\u9646\u524d\u67e5\u770b\u6240\u6709\u5355\u4f4d")
    @GetMapping(value={"searchCompanyListForWqxx"})
    public ResponseData<LayuiGridData<WxCompanyListVo>> searchCompanyListForWqxx(String companyName, Integer pageNum, Integer pageSize) {
        CompanySuperviseSearchModel param = new CompanySuperviseSearchModel();
        param.setSystemDeploymentSource(SystemDeploymentSourceEnum.ONLINE_TRAINING.getCode());
        param.setName(companyName);
        PageInfo list = this.companyProvideBySuperviseService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(param, pageNum.intValue(), pageSize.intValue(), Boolean.valueOf(false));
        if (CollUtil.isEmpty((Collection)list.getList())) {
            return new ResponseData();
        }
        ArrayList<WxCompanyListVo> rstList = new ArrayList<WxCompanyListVo>(list.getList().size());
        for (CompanySuperviseModel vo : list.getList()) {
            rstList.add(new WxCompanyListVo(vo.getCid(), vo.getName(), vo.getAreaId(), vo.getBelongType()));
        }
        return new ResponseData((Object)new LayuiGridData(rstList, pageNum, pageSize, Integer.valueOf((int)list.getTotal()), null));
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4f4d\u5217\u8868-\u7528\u4e8e\u5207\u6362\u5355\u4f4d")
    @GetMapping(value={"searchCompanyStaffList"})
    public ResponseData<List<CompanyListVo>> searchCompanyStaffList() {
        return new ResponseData((Object)this.companyStaffProviderService.getByUidAndSource(ShiroUtil.getLoginUserId(), null));
    }

    @ApiOperation(value="\u5237\u65b0\u767b\u5f55\u4fe1\u606fcompanyId")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cid", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="companyName", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/flushCompanyId"})
    public ResponseData<String> flushOrgId(@NotNull Long cid, @NotNull String companyName) {
        ShiroUtil.flushCid(cid, companyName);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getWXLoginUserKey((Long)ShiroUtil.getLoginUserId()), (Object)ShiroUtil.getShiroPrincipal(), Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        this.companyStaffProviderService.saveWithSource(cid, ShiroUtil.getLoginUserId(), ShiroUtil.getLoginUserId(), Integer.valueOf(2));
        return ResponseData.success((String)"");
    }

    @Generated
    public WqxxPersonalCenterController(OssClientBean ossClientBean, BaiduApiService baiduApiService, H5Converter converter, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.ossClientBean = ossClientBean;
        this.baiduApiService = baiduApiService;
        this.converter = converter;
        this.redisTemplate = redisTemplate;
    }
}

