/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.user;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.IdParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserTrainStatusNumVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personal/train"})
public class UserTrainingController
extends ControllerSupport {
    @DubboReference
    private ITrainingProviderServiceForUser iTrainingProviderServiceForUser;
    @DubboReference
    private ITrainingCourseProviderService iTrainingCourseProviderService;

    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getTrainingList(TrainingSearchParam param) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainingPageListForUser(param));
    }

    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<UserMyTrainListVo> getTrainingBaseInfo(Long tid) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainingBaseInfoForUser(tid, uid));
    }

    @GetMapping(value={"getTrainingCourseGroup"})
    public ResponseData<List<TrainingCourseGroupVo>> getTrainingCourseGroup(Long tid) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainingCourseGroup(tid, uid));
    }

    @GetMapping(value={"getTrainingCourse"})
    public ResponseData<List<UserMyTrainCourseVo>> getTrainingCourse(Long tid, Long courseGroupId) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainingCourse(tid, uid, courseGroupId));
    }

    @GetMapping(value={"getTrainingStatusNumList"})
    public ResponseData<List<UserTrainStatusNumVo>> getTrainingStatusNumList() {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainingStatusNumListForUser(uid));
    }

    @GetMapping(value={"getMyTrainingList"})
    public ResponseData<LayuiGridData<UserMyTrainListVo>> getMyTrainingList(UserMyTrainSearchParam param) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainPageListForUser(param));
    }

    @GetMapping(value={"getMyTrainingBaseInfo"})
    public ResponseData<UserMyTrainListVo> getMyTrainingBaseInfo(Long tid, Long enrollDetailId) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainingBaseInfoForUser(tid, uid, enrollDetailId));
    }

    @GetMapping(value={"getNewTrainCourse"})
    public ResponseData<List<TrainingNewCourseGroupVo>> getNewTrainCourse(TrainingSearchParam param) {
        param.setUid(ShiroUtil.getLoginUserId());
        return new ResponseData((Object)this.iTrainingCourseProviderService.getNewTrainCourseList(param));
    }

    @GetMapping(value={"getMyTrainingCourseGroup"})
    public ResponseData<List<TrainingCourseGroupVo>> getMyTrainingCourseGroup(Long tid) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainingCourseGroup(tid, uid));
    }

    @GetMapping(value={"getMyTrainingCourse"})
    public ResponseData<List<UserMyTrainCourseVo>> getMyTrainingCourse(Long tid, Long courseGroupId) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getMyTrainingCourse(tid, uid, courseGroupId));
    }

    @PostMapping(value={"delMyTraining"})
    public ResponseData<String> delTrainingForUser(@RequestBody IdParam tid) {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        Long uid = ShiroUtil.getLoginUserId();
        this.iTrainingProviderServiceForUser.delTrainingForUser(tid.getId(), uid);
        return ResponseData.success();
    }

    @GetMapping(value={"getTrainingWorkType"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType() {
        if (ShiroUtil.getLoginUserId() == null) {
            return ResponseData.fail((String)"\u8bf7\u5148\u767b\u5f55\u4e2a\u4eba\u7528\u6237");
        }
        return new ResponseData((Object)this.iTrainingProviderServiceForUser.getTrainingWorkType(ShiroUtil.getLoginUserId()));
    }
}

