/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.user;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IMsgProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysParamVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.User;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personal/uc"})
@Validated
public class PersonalCenterController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonalCenterController.class);
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysParamProviderService sysParamProviderService;
    @DubboReference
    private IMsgProviderService msgProviderService;

    @PostMapping(value={"/getPersonalInfo"})
    public ResponseData<PersonalUserVo> getPersonalInfo(@RequestParam(required=false) Boolean isBrief) {
        PersonalUserVo personalUserInfo;
        if ((isBrief = Boolean.valueOf(isBrief == null || isBrief != false)).booleanValue()) {
            User user = ShiroUtil.getShiroPrincipal().getUser();
            UserInfo userInfo = ShiroUtil.getShiroPrincipal().getUserInfo();
            personalUserInfo = new PersonalUserVo();
            personalUserInfo.setId(user.getId()).setUserType(Integer.valueOf(1)).setName(user.getName()).setEmail(user.getEmail()).setAvatar(user.getAvatar());
            SysParam education = null;
            SysParam workType = null;
            if (userInfo.getEducation() != null) {
                education = this.sysParamProviderService.getByCode(userInfo.getEducation());
            }
            if (userInfo.getEducation() != null) {
                workType = this.sysParamProviderService.getByCode(userInfo.getWorkType());
            }
            personalUserInfo.setPhotoUrl(userInfo.getPhotoUrl()).setEducation(userInfo.getEducation()).setEducationStr(education == null ? null : education.getName()).setWorkType(userInfo.getWorkType()).setWorkTypeStr(workType == null ? null : workType.getName()).setRadiationWorkDate(userInfo.getRadiationWorkDate()).setIdcard(userInfo.getIdcard());
            personalUserInfo.setUnreadMsgNum(this.msgProviderService.getUnreadMsgNum(user.getId()));
        } else {
            personalUserInfo = this.userProviderService.getPersonalUserInfo(ShiroUtil.getLoginUserId());
        }
        personalUserInfo.setIsBrief(isBrief);
        return ResponseData.success((Object)personalUserInfo);
    }

    @PostMapping(value={"/editUser"})
    public ResponseData<String> editUser(@RequestBody EditUserParam editUserParam) {
        try {
            this.userProviderService.editPersonal(editUserParam);
            return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (DuplicateKeyException e) {
            log.error("Exception\uff1a", (Throwable)e);
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"/updateHeadImg"})
    public ResponseData updateHeadImg(@RequestBody UpdateHeadImgParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        this.userProviderService.updateHeadImg(param);
        return ResponseData.success();
    }

    @GetMapping(value={"getWorkTypeList"})
    public ResponseData<List<SysParamVo>> getTrainingWorkType() {
        return new ResponseData((Object)this.sysParamProviderService.getParamList(new ParamQueryParam().setPcode("100").setIsForbidden(Integer.valueOf(0))));
    }

    @GetMapping(value={"getEducations"})
    public ResponseData<List<SysParamVo>> getEducations() {
        return new ResponseData((Object)this.sysParamProviderService.getParamList(new ParamQueryParam().setPcode("104").setIsForbidden(Integer.valueOf(0))));
    }

    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPassword(@NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password) {
        this.userProviderService.modifyPassword(ShiroUtil.getLoginUserId(), password);
        return ResponseData.success();
    }

    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String newPassword) {
        this.userProviderService.modifyPasswordByOldPwd(ShiroUtil.getLoginUserId(), oldPassword, newPassword);
        return ResponseData.success();
    }

    @Generated
    public PersonalCenterController() {
    }
}

