/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.corp;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFeedbackProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropDeleteOneEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RemoveStaffParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SearchRegListParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SearchStaffTrainingDetailParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SendBackParam;
import cn.smarthse.radiationTraining.modules.training.param.training.CorpMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForCorp;
import cn.smarthse.radiationTraining.modules.training.vo.course.EnrollInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.StaffTrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CorpMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CropTrainStatusNumVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/crop/train"})
public class CorpTrainingController
extends ControllerSupport {
    @DubboReference
    private ITrainingProviderServiceForCorp iTrainingProviderServiceForCorp;
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private ISysFeedbackProviderService sysFeedbackProviderService;

    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getTrainingList(TrainingSearchParam param) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        Integer userType = ShiroUtil.getShiroPrincipal().getUserType();
        if (Objects.equals(userType, SysUserTypeEnum.COMPANY.getValue())) {
            param.setTrainTarget(Integer.valueOf(0));
        }
        param.setCid(companyInfo.getId());
        param.setAreaId(companyInfo.getAreaId());
        param.setBelongType(companyInfo.getBelongType());
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingPageListForCorp(param));
    }

    @GetMapping(value={"getTrainingStatusNumList"})
    public ResponseData<List<CropTrainStatusNumVo>> getTrainingStatusNumList(Integer trainTargetType) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingStatusNumListForCrop(companyInfo.getId(), trainTargetType));
    }

    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<TrainingBaseInfoVo> getTrainingBaseInfo(TrainingSearchParam param) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        param.setCid(companyInfo.getId());
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingBaseInfoForCorp(param));
    }

    @GetMapping(value={"getTrainingCourseGroup"})
    public ResponseData<List<TrainingCourseGroupVo>> getTrainingCourseGroup(Long tid) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingCourseGroupForCorp(tid, companyInfo.getId()));
    }

    @GetMapping(value={"getTrainingCourse"})
    public ResponseData<List<TrainingCourseVo>> getTrainingCourse(Long tid, Long trainCourseGroupId) {
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingCourseForCorp(tid, trainCourseGroupId));
    }

    @GetMapping(value={"getMyTrainingList"})
    public ResponseData<LayuiGridData<CorpMyTrainListVo>> getMyTrainingList(CorpMyTrainSearchParam param) {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        param.setCid(companyInfo.getId());
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getMyTrainPageListForCorp(param));
    }

    @GetMapping(value={"getTrainingWorkType"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType() {
        CompanyInfo companyInfo = ShiroUtil.getShiroPrincipal().getCompanyInfo();
        return new ResponseData((Object)this.iTrainingProviderServiceForCorp.getTrainingWorkType(companyInfo.getId()));
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"searchEnrollList"})
    public ResponseData<LayuiGridData<EnrollInfoVo>> searchEnrollList(SearchRegListParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        return ResponseData.success((Object)this.enrollProviderService.searchEnrollList(param));
    }

    @Log(title="\u62a5\u540d\u6e05\u5355-\u9000\u56de\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_crop, type=LogTypeEnum.type_opt_edit)
    @PostMapping(value={"sendBack"})
    public ResponseData sendBack(@RequestBody SendBackParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        this.enrollProviderService.cropToSendBack(param);
        return ResponseData.success();
    }

    @Log(title="\u62a5\u540d\u6e05\u5355-\u5220\u9664\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_crop, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"deleteStaff"})
    public ResponseData deleteStaff(@RequestBody RemoveStaffParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        this.enrollProviderService.cropToDeleteStaff(param);
        return ResponseData.success();
    }

    @Log(title="\u62a5\u540d\u6e05\u5355-\u6279\u91cf\u5220\u9664\u7528\u6237\u62a5\u540d", logModule=LogModuleTypeEnum.user_enroll_crop, type=LogTypeEnum.type_opt_del)
    @PostMapping(value={"deleteStaffBatch"})
    public ResponseData deleteStaffBatch(@RequestBody List<RemoveStaffParam> paramList) {
        Long cid = ShiroUtil.getShiroPrincipal().getCompanyInfo().getId();
        for (RemoveStaffParam v : paramList) {
            v.setCid(cid);
            v.setLoginUserId(ShiroUtil.getLoginUserId());
            v.setLoginUsername(ShiroUtil.getLoginUsername());
        }
        this.enrollProviderService.cropTodeleteStaffBatch(paramList);
        return ResponseData.success();
    }

    @GetMapping(value={"getStaffTrainingDetail"})
    public ResponseData<LayuiGridData<StaffTrainingDetailVo>> getStaffTrainingDetail(SearchStaffTrainingDetailParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        return ResponseData.success((Object)this.enrollProviderService.getStaffTrainingDetail(param));
    }

    @Log(title="\u5355\u4f4d\u7528\u6237\u4e2d\u5fc3-\u5220\u9664\u5355\u4f4d\u62a5\u540d", logModule=LogModuleTypeEnum.unit_enroll_crop, type=LogTypeEnum.type_opt_del)
    @GetMapping(value={"cropToDeleteOneEnroll"})
    public ResponseData cropToDeleteOneEnroll(CropDeleteOneEnrollParam param) {
        param.setCid(ShiroUtil.getShiroPrincipal().getCompanyInfo().getId());
        this.enrollProviderService.cropToDeleteOneEnroll(param);
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f");
    }
}

