/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.corp;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.radiationTraining.modules.sys.param.sys.AddSysCompanyRiskParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveFeedbackParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.EditCropParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFeedbackProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.ICompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropSelectTraninglParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.GenerateEnrollQRCodeParam;
import cn.smarthse.radiationTraining.modules.training.provider.enroll.ITuEnrollProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollQRCodeVo;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/corp/uc"})
@Validated
public class CorpCenterController {
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    private ICompanyProviderService companyProviderService;
    @DubboReference
    private ITuEnrollProviderService enrollProviderService;
    @DubboReference
    private ISysFeedbackProviderService sysFeedbackProviderService;

    @GetMapping(value={"/getCorpInfo"})
    public ResponseData<UserCropVo> getCorpInfo() {
        return ResponseData.success((Object)this.userCropProviderService.getFullUserInfo(ShiroUtil.getLoginUserId()));
    }

    @PostMapping(value={"/updateHeadImg"})
    public ResponseData updateHeadImg(@RequestBody UpdateHeadImgParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        this.userCropProviderService.updateHeadImg(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/save"})
    public ResponseData save(@RequestBody EditCropParam param) {
        param.getSaveUserCropParam().setLoginUserId(param.getLoginUserId());
        param.getSaveUserCropParam().setUserId(param.getLoginUserId());
        this.userCropProviderService.saveUserAndCompany(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/syn/risk"})
    public ResponseData synRisk(@RequestBody List<AddSysCompanyRiskParam> paramList) {
        this.companyProviderService.synRiskFactor(paramList);
        return ResponseData.success();
    }

    @PostMapping(value={"/feedback"})
    public ResponseData feedback(@RequestBody SaveFeedbackParam param) {
        this.sysFeedbackProviderService.feedback(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/selectTraining"})
    @RequestLimit(second=30, maxCount=1)
    public ResponseData selectTraining(@RequestBody CropSelectTraninglParam param) {
        param.setUserType(ShiroUtil.getUserType());
        this.enrollProviderService.enroll(param);
        return ResponseData.success((String)"\u62a5\u540d\u6210\u529f");
    }

    @PostMapping(value={"/generateQRCodeContent"})
    public ResponseData generateQRCodeContent(@RequestBody GenerateEnrollQRCodeParam param) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.enrollProviderService.generateQRCodeContent(param));
    }

    @PostMapping(value={"/getQRCodeContent"})
    public ResponseData<EnrollQRCodeVo> getQRCodeContent(@RequestBody GenerateEnrollQRCodeParam param) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.enrollProviderService.getQRCodeContent(param));
    }

    @Generated
    public CorpCenterController() {
    }
}

