/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller.api;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/train"})
public class ApiTrainingController
extends ControllerSupport {
    @DubboReference
    private ITrainingProviderService iTrainingProviderService;
    @DubboReference
    private ITrainingProviderServiceForUser iTrainingProviderServiceForUser;
    @DubboReference
    private ITrainingCourseProviderService iTrainingCourseProviderService;

    @GetMapping(value={"getTrainingList"})
    public ResponseData<LayuiGridData<TrainingListVo>> getTrainingList(TrainingSearchParam param) {
        return new ResponseData((Object)this.iTrainingProviderService.getTrainingPageListForApi(param));
    }

    @GetMapping(value={"getTrainingBaseInfo"})
    public ResponseData<TrainingBaseInfoVo> getTrainingBaseInfo(TrainingSearchParam param) {
        return new ResponseData((Object)this.iTrainingProviderService.getTrainingBaseInfo(param));
    }

    @GetMapping(value={"getTrainingCourseGroup"})
    public ResponseData<List<TrainingCourseGroupVo>> getTrainingCourseGroup(Long tid) {
        return new ResponseData((Object)this.iTrainingCourseProviderService.getTrainingCourseGroupForApi(tid));
    }

    @GetMapping(value={"getTrainingCourse"})
    public ResponseData<List<TrainingCourseVo>> getTrainingCourse(Long tid, Long courseGroupId) {
        return new ResponseData((Object)this.iTrainingCourseProviderService.getTrainingCourseForApi(tid, courseGroupId));
    }

    @GetMapping(value={"getTrainingWorkType"})
    public ResponseData<List<TrainingWorkTypeVo>> getTrainingWorkType() {
        return new ResponseData((Object)this.iTrainingProviderService.getTrainWorkTypeByStatus(Integer.valueOf(2)));
    }
}

