/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.system.SysOperationFileModel;
import cn.smarthse.modules.datacentre.model.system.SysOperationFileVo;
import cn.smarthse.modules.datacentre.provider.system.ISysOperationFileProvideService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.ShiroUtil;
import jakarta.servlet.http.HttpServletRequest;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/operation/file"})
public class SysOperationFileController {
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysOperationFileProvideService sysOperationFileProvideService;

    @GetMapping(value={"/getFilesByUrlAndType"})
    public ResponseData<SysOperationFileVo> getFilesByUrlAndType(SysOperationFileModel model, HttpServletRequest request) {
        try {
            model.setRemarks(request.getServerName());
            Integer userType = ShiroUtil.getUserType();
            model.setPermissions(ObjectUtil.isNull((Object)userType) ? null : userType.toString());
            SysOperationFileVo filesByUrlAndType = this.sysOperationFileProvideService.getFilesByUrlAndType(model);
            return ResponseData.success((Object)filesByUrlAndType);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }
}

