/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.www.controller;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.annotation.Log;
import cn.smarthse.radiationTraining.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.annotation.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.utils.AesUtil;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.www.bootstrap.security.token.LoginData;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotEmpty;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference
    private IUserProviderService userProviderService;

    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u767b\u5165")
    @RequestLimit(second=60, maxCount=5, msg="\u8bf71\u5206\u949f\u540e\u91cd\u8bd5")
    @PostMapping(value={"/password"})
    public ResponseData<LoginData> loginByPassword(String username, @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotEmpty(message="\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer userType, @NotEmpty(message="\u9a8c\u8bc1\u7801key") @NotEmpty(message="\u9a8c\u8bc1\u7801key") String key, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String vode) {
        if (!this.loginService.checkVcode(key, vode, true)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return ResponseData.success((Object)this.loginService.loginByPassword(username, password, userType));
    }

    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u767b\u5165")
    @RequestLimit(second=60, maxCount=5, msg="\u8bf71\u5206\u949f\u540e\u91cd\u8bd5")
    @PostMapping(value={"/code"})
    public ResponseData<LoginData> loginByCode(String phone, @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") String code) {
        return ResponseData.success((Object)this.loginService.loginByCode(phone, code));
    }

    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module11)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u5355\u4f4d\u5355\u70b9\u767b\u5165")
    @PostMapping(value={"/rayCas"})
    public ResponseData<LoginData> loginByRayCas(String sign) {
        String decrypt = AesUtil.decrypt((String)sign);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        String username = (String)jsonObject.getObject("username", String.class, new JSONReader.Feature[0]);
        String name = (String)jsonObject.getObject("name", String.class, new JSONReader.Feature[0]);
        String creditCode = (String)jsonObject.getObject("creditCode", String.class, new JSONReader.Feature[0]);
        Long areaId = (Long)jsonObject.getObject("areaId", Long.class, new JSONReader.Feature[0]);
        Long token = (Long)jsonObject.getObject("token", Long.class, new JSONReader.Feature[0]);
        Long time = (Long)jsonObject.getObject("time", Long.class, new JSONReader.Feature[0]);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class, new JSONReader.Feature[0]);
        Integer isTest = (Integer)jsonObject.getObject("isTest", Integer.class, new JSONReader.Feature[0]);
        long expreTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        CasToken casToken = new CasToken(username, name, creditCode, areaId, token, isTest);
        LoginData result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module10)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u5355\u4f4d\u5355\u70b9\u767b\u5165")
    @PostMapping(value={"/cas"})
    public ResponseData<LoginData> loginByCas(String sign) {
        String decrypt = AesUtil.decrypt((String)sign);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        String username = (String)jsonObject.getObject("username", String.class, new JSONReader.Feature[0]);
        String name = (String)jsonObject.getObject("name", String.class, new JSONReader.Feature[0]);
        String creditCode = (String)jsonObject.getObject("creditCode", String.class, new JSONReader.Feature[0]);
        Long areaId = (Long)jsonObject.getObject("areaId", Long.class, new JSONReader.Feature[0]);
        String industryCode = (String)jsonObject.getObject("industryCode", String.class, new JSONReader.Feature[0]);
        String contactTel = (String)jsonObject.getObject("contactTel", String.class, new JSONReader.Feature[0]);
        String email = (String)jsonObject.getObject("email", String.class, new JSONReader.Feature[0]);
        Long token = (Long)jsonObject.getObject("token", Long.class, new JSONReader.Feature[0]);
        Long time = (Long)jsonObject.getObject("time", Long.class, new JSONReader.Feature[0]);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class, new JSONReader.Feature[0]);
        Integer isTest = (Integer)jsonObject.getObject("isTest", Integer.class, new JSONReader.Feature[0]);
        Integer superviseIsHide = (Integer)jsonObject.getObject("superviseIsHide", Integer.class, new JSONReader.Feature[0]);
        Integer belongType = (Integer)jsonObject.getObject("belongType", Integer.class, new JSONReader.Feature[0]);
        Integer businessState = (Integer)jsonObject.getObject("businessState", Integer.class, new JSONReader.Feature[0]);
        long expreTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        CasToken casToken = new CasToken(username, name, creditCode, areaId, industryCode, contactTel, email, token, isTest, superviseIsHide, belongType, businessState);
        LoginData result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module12)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u5355\u4f4d\u5355\u70b9\u767b\u5165")
    @PostMapping(value={"/orgCas"})
    public ResponseData<LoginData> loginByOrgCas(String sign) {
        String decrypt = AesUtil.decrypt((String)sign);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        String username = (String)jsonObject.getObject("username", String.class, new JSONReader.Feature[0]);
        String name = (String)jsonObject.getObject("name", String.class, new JSONReader.Feature[0]);
        String creditCode = (String)jsonObject.getObject("creditCode", String.class, new JSONReader.Feature[0]);
        Long areaId = (Long)jsonObject.getObject("areaId", Long.class, new JSONReader.Feature[0]);
        Long token = (Long)jsonObject.getObject("token", Long.class, new JSONReader.Feature[0]);
        Integer isTest = (Integer)jsonObject.getObject("isTest", Integer.class, new JSONReader.Feature[0]);
        Integer superviseIsHide = (Integer)jsonObject.getObject("superviseIsHide", Integer.class, new JSONReader.Feature[0]);
        Long time = (Long)jsonObject.getObject("time", Long.class, new JSONReader.Feature[0]);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class, new JSONReader.Feature[0]);
        long expreTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        CasToken casToken = new CasToken(username, name, creditCode, areaId, token, isTest, superviseIsHide);
        LoginData result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @PostMapping(value={"/modifyPasswordByEmail"})
    public ResponseData<String> modifyPasswordByEmail(String email, @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password) {
        this.loginService.modifyPasswordByEmail(email, code, password);
        return ResponseData.success();
    }

    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String newPassword, HttpServletRequest request) {
        Long userId = JwtUtil.getUserId((String)request.getHeader(Constant.TOKEN_HEADER_NAME));
        if (userId == null) {
            return ResponseData.fail((String)"\u672a\u767b\u5f55!");
        }
        this.userProviderService.modifyPasswordByOldPwd(userId, oldPassword, newPassword);
        return ResponseData.success();
    }

    @RequestLimit(second=60, maxCount=2)
    @PostMapping(value={"/sendEmailCode"})
    public ResponseData<Boolean> sendEmailCode(String email) {
        return ResponseData.success((Object)this.loginService.sendEmailCode(email));
    }

    @RequestLimit(second=60, maxCount=2)
    @PostMapping(value={"/sendMobileCode"})
    public ResponseData<Boolean> sendMobileCode(String mobile) {
        return ResponseData.success((Object)this.loginService.sendLoginCode(mobile));
    }

    @PostMapping(value={"/sendVcode"})
    public ResponseData<String> sendVcode(@NotEmpty(message="key\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="key\u4e0d\u80fd\u4e3a\u7a7a") String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVcode(key));
    }

    @PostMapping(value={"/checkEmailCode"})
    public ResponseData<Boolean> checkEmailCode(String email, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String code) {
        return ResponseData.success((Object)this.loginService.checkEmailCode(email, code));
    }

    @PostMapping(value={"/checkVcode"})
    public ResponseData<Boolean> checkVcode(String key, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String vode) {
        return ResponseData.success((Object)this.loginService.checkVcode(key, vode, false));
    }

    @Generated
    public LoginController(LoginService loginService) {
        this.loginService = loginService;
    }
}

